/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import org.w3c.dom.Node;

import woolpack.fn.Fn;

/**
 * 指定された DOM ノードをテキストノードに置き換える{@link Fn}です。
 * 取得した値が null の場合は値を更新しません。
 * 
 * @author nakamura
 * 
 */
public class TextReplacer<C extends NodeContext> implements Fn<C, Void> {
	private Fn<? super C, String> fn;

	public TextReplacer(final Fn<? super C, String> fn) {
		this.fn = fn;
	}

	public Void exec(final C context) {
		final Node node = context.getNode();
		final String value = fn.exec(context);
		if (value != null) {
			node.getParentNode().insertBefore(
					XmlUtils.getDocumentNode(node).createTextNode(value),
					node);
			XmlUtils.removeThis(node);
		}
		return null;
	}

	public Fn<? super C, String> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super C, String> fn) {
		this.fn = fn;
	}
}
