/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import woolpack.fn.Fn;
import woolpack.xml.NodeContext;

/**
 * テーブルの行毎の属性値を循環的に設定する{@link Fn}です。
 * @author nakamura
 *
 */
public class RowAttrConverter implements Fn<NodeContext, Void> {
	private String attrName;
	private String[] attrValueArray;
	
	public RowAttrConverter(final String attrName, final String[] attrValueArray) {
		this.attrName = attrName;
		this.attrValueArray = attrValueArray;
	}

	public Void exec(final NodeContext c) {
	    final NodeList trList = HtmlUtils.TR.evaluateList(c.getNode());
	    for (int i = 0; i < trList.getLength(); i++) {
	      ((Element) trList.item(i)).setAttribute(attrName, attrValueArray[i % attrValueArray.length]);
	    }
		return null;
	}

	public String getAttrName() {
		return attrName;
	}
	public void setAttrName(final String attrName) {
		this.attrName = attrName;
	}
	public String[] getAttrValueArray() {
		return attrValueArray;
	}
	public void setAttrValueArray(final String[] attrValueArray) {
		this.attrValueArray = attrValueArray;
	}
}
