/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.factory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

import woolpack.fn.Fn;

/**
 * 文字列のバイト配列表現を返すテスト用の{@link Fn}です。
 * 
 * @author nakamura
 * 
 */
public class StringInputStreamFactory implements Fn<Object, InputStream> {
	private String charset;
	private String content;

	public StringInputStreamFactory(final String charset, final String content) {
		this.charset = charset;
		this.content = content;
	}

	/**
	 * @throws IllegalStateException ({@link UnsupportedEncodingException})
	 */
	public InputStream exec(final Object c) {
		final byte[] array;
		try {
			if (charset == null || charset.length() == 0) {
				array = content.getBytes();
			} else {
				array = content.getBytes(charset);
			}
		} catch (final UnsupportedEncodingException e) {
			throw new IllegalStateException(e);
		}
		return new ByteArrayInputStream(array);
	}

	public String getCharset() {
		return charset;
	}
	public void setCharset(final String charset) {
		this.charset = charset;
	}
	public String getContent() {
		return content;
	}
	public void setContent(final String s) {
		this.content = s;
	}
}
