/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.container;

import woolpack.fn.Fn;

/**
 * インタープリタ デザインパターンとダブルディスパッチを使用した、
 * オブジェクトの生成をフラット構造で定義するためコンテキストです。
 * <br/>適用しているデザインパターン：Interpreter(Context役)。
 * @author nakamura
 *
 * @param <S> サブコンテキスト。
 */
public class ContainerContext<S> {
	private Fn<? super ContainerContext<S>, ?> fn;
	private Object key;
	private S subContext;
	
	/**
	 * 引数のキーを一時的に設定して委譲し、
	 * 委譲先から復帰したときに呼び出し時の状態に初期化します。
	 * @param key
	 * @return 生成されたオブジェクト。
	 */
	public Object visit(final Object key) {
		final Object baseKey = this.key;
		this.key = key;
		try {
			return fn.exec(this);
		} finally {
			this.key = baseKey;
		}
	}
	
	public Object getKey() {
		return key;
	}
	public void setKey(final Object key) {
		this.key = key;
	}
	public Fn<? super ContainerContext<S>, ?> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super ContainerContext<S>, ?> fn) {
		this.fn = fn;
	}
	public S getSubContext() {
		return subContext;
	}
	public void setSubContext(final S subContext) {
		this.subContext = subContext;
	}
}
