/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import woolpack.bool.BooleanOperator;
import woolpack.fn.Fn;
import woolpack.utils.Utils;
import woolpack.validator.ConvertValidator;
import woolpack.validator.LocalIndexValidator;
import woolpack.validator.LocalKeyValidator;
import woolpack.validator.MapGetter;
import woolpack.validator.MessageValidator;
import woolpack.validator.NameBranch;
import woolpack.validator.NameBranchIfExists;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValueGetter;
import woolpack.validator.ValueLoopValidator;
import woolpack.validator.ValuesGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorUtils {
    public static final ValueGetter VALUE = new ValueGetter();
    public static final MapGetter MAP = new MapGetter();
    public static final ValuesGetter VALUES = new ValuesGetter();

    private ValidatorUtils() {
    }

    public static Map<String, List<Object>> convert(Map map) {
        HashMap<String, List<Object>> map1 = new HashMap<String, List<Object>>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            Iterable c = Utils.toIterable(entry.getValue());
            ArrayList list = new ArrayList();
            for (Object o : c) {
                list.add(o);
            }
            map1.put((String)entry.getKey(), list);
        }
        return map1;
    }

    public static NameBranchIfExists branchByNameIfExists(BooleanOperator<ValidatorContext> operator, Map<String, ? extends Fn<ValidatorContext, Boolean>> map) {
        return new NameBranchIfExists(operator, map);
    }

    public static NameBranchIfExists branchByNameIfExists(Map<String, ? extends Fn<ValidatorContext, Boolean>> map) {
        return new NameBranchIfExists(map);
    }

    public static NameBranch branchByName(BooleanOperator<ValidatorContext> operator, Map<String, ? extends Fn<ValidatorContext, Boolean>> map) {
        return new NameBranch(operator, map);
    }

    public static NameBranch branchByName(Map<String, ? extends Fn<ValidatorContext, Boolean>> map) {
        return new NameBranch(map);
    }

    public static ConvertValidator convertValue(Fn<Object, ?> fn) {
        return new ConvertValidator(fn);
    }

    public static MessageValidator message(String message) {
        return new MessageValidator(message);
    }

    public static LocalIndexValidator localIndex(int tmpIndex, Fn<ValidatorContext, Boolean> fn) {
        return new LocalIndexValidator(tmpIndex, fn);
    }

    public static LocalKeyValidator localKey(String tmpKey, Fn<ValidatorContext, Boolean> fn) {
        return new LocalKeyValidator(tmpKey, fn);
    }

    public static ValueLoopValidator loopValue(BooleanOperator<ValidatorContext> operator, Fn<? super ValidatorContext, Boolean> fn) {
        return new ValueLoopValidator(operator, fn);
    }

    public static ValueLoopValidator loopValue(Fn<? super ValidatorContext, Boolean> fn) {
        return new ValueLoopValidator(fn);
    }
}

