/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.bool.BoolUtils;
import woolpack.convert.ConvertUtils;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.html.AutoUpdater;
import woolpack.html.BranchPropertyCounter;
import woolpack.html.CaseNormalizer;
import woolpack.html.CommentRemover;
import woolpack.html.HiddenAppender;
import woolpack.html.MergeCell;
import woolpack.html.MergeCellAll;
import woolpack.html.RadioRemaker;
import woolpack.html.RowAttrConverter;
import woolpack.html.RowIndexInserter;
import woolpack.html.SelectRemaker;
import woolpack.html.SelectedValueUpdater;
import woolpack.html.SpaceCompressor;
import woolpack.html.ThisAndTextsRemover;
import woolpack.html.ValueUpdater;
import woolpack.xml.NodeContext;
import woolpack.xml.NodeFindable;
import woolpack.xml.NodeFindableChildNodesImpl;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlUtils {
    public static final SpaceCompressor COMPRESS_SPACE = new SpaceCompressor();
    public static final MergeCellAll MERGE_CELL_ALL = new MergeCellAll();
    public static final CaseNormalizer NORMALIZE_CASE = new CaseNormalizer();
    public static final CommentRemover REMOVE_COMMENT = new CommentRemover();
    public static final ThisAndTextsRemover REMOVE_THIS_AND_TEXTS = new ThisAndTextsRemover();
    static final NodeFindable TR = new NodeFindableChildNodesImpl((Fn<Node, Boolean>)FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("TR")), false);
    static final NodeFindable TD = new NodeFindableChildNodesImpl((Fn<Node, Boolean>)FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("TD")), false);

    private HtmlUtils() {
    }

    public static void removeThisAndText(Node node) {
        Node nextNode = node.getNextSibling();
        while (nextNode != null && nextNode.getNodeType() == 3) {
            XmlUtils.removeThis(nextNode);
            nextNode = node.getNextSibling();
        }
        XmlUtils.removeThis(node);
    }

    public static AutoUpdater updateAuto(Iterable<String> attrNames, GettingEL componentEL, GettingEL configEL, Set<Class> atomSet, GettingEL errorEL) {
        return new AutoUpdater(attrNames, componentEL, configEL, atomSet, errorEL);
    }

    public static AutoUpdater updateAuto(Iterable<String> attrNames, GettingEL componentEL, GettingEL configEL) {
        return new AutoUpdater(attrNames, componentEL, configEL);
    }

    public static <C extends NodeContext> BranchPropertyCounter<C> branchPropertyCount(EL el, Iterable<String> attrNames, Fn<? super C, Void> firstFn, Fn<? super C, Void> pluralFn) {
        return new BranchPropertyCounter<C>(el, attrNames, firstFn, pluralFn);
    }

    public static RowAttrConverter convertRowAttr(String attrName, String[] attrValueArray) {
        return new RowAttrConverter(attrName, attrValueArray);
    }

    public static HiddenAppender hiddenAllToChild(GettingEL mapEL, Collection<String> excludeProperties) {
        return new HiddenAppender(mapEL, excludeProperties);
    }

    public static RowIndexInserter insertRowIndex(String headValue) {
        return new RowIndexInserter(headValue);
    }

    public static RadioRemaker makeRadio(GettingEL mapEL) {
        return new RadioRemaker(mapEL);
    }

    public static SelectRemaker makeSelect(GettingEL mapEL) {
        return new SelectRemaker(mapEL);
    }

    public static MergeCell mergeCell(int colIndex) {
        return new MergeCell(colIndex);
    }

    public static SelectedValueUpdater updateToSelectedValue(GettingEL valueEL, GettingEL mapEL) {
        return new SelectedValueUpdater(valueEL, mapEL);
    }

    public static ValueUpdater updateValue(GettingEL valueEL, GettingEL mapEL, boolean selectFlag) {
        return new ValueUpdater(valueEL, mapEL, selectFlag);
    }

    public static ValueUpdater updateValue(GettingEL valueEL, GettingEL mapEL) {
        return new ValueUpdater(valueEL, mapEL);
    }

    public static ValueUpdater updateValue(GettingEL valueEL) {
        return new ValueUpdater(valueEL);
    }

    public static Fn<NodeContext, Void> removeExtension(final String elementName, final String attrName) {
        return XmlUtils.findNode(new NodeFindableChildNodesImpl(new Fn<Node, Boolean>(){

            @Override
            public Boolean exec(Node c) {
                if (c.getNodeType() == 1 && elementName.equals(c.getNodeName()) && ((Element)c).hasAttribute(attrName)) {
                    return true;
                }
                return false;
            }
        }, true), XmlUtils.updateAttrValue(attrName, (Fn)FnUtils.join(XmlUtils.getAttrValue(attrName), ConvertUtils.convertRegExp(Pattern.compile("^([^\\.]+)\\.[^\\.]+$"), "$1"))));
    }
}

