/*
 * Decompiled with CFR 0.152.
 */
package woolpack.factory;

import java.util.Map;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapCache<C, K>
implements Fn<C, Object> {
    private Fn<? super C, ? extends Map<? super K, Object>> mapGetter;
    private Fn<? super C, ? extends K> keyGetter;
    private Fn<? super C, ?> maker;

    public MapCache(Fn<? super C, ? extends Map<? super K, Object>> mapGetter, Fn<? super C, K> keyGetter, Fn<? super C, ?> maker) {
        this.mapGetter = mapGetter;
        this.keyGetter = keyGetter;
        this.maker = maker;
    }

    @Override
    public Object exec(C c) {
        K key;
        Map<K, Object> map = this.mapGetter.exec(c);
        Object value = map.get(key = this.keyGetter.exec(c));
        if (value == null) {
            value = this.maker.exec(c);
            map.put(key, value);
            return value;
        }
        return value;
    }

    public Fn<? super C, ? extends K> getKeyGetter() {
        return this.keyGetter;
    }

    public void setKeyGetter(Fn<? super C, ? extends K> keyGetter) {
        this.keyGetter = keyGetter;
    }

    public Fn<? super C, ?> getMaker() {
        return this.maker;
    }

    public void setMaker(Fn<? super C, ?> maker) {
        this.maker = maker;
    }

    public Fn<? super C, ? extends Map<? super K, Object>> getMapGetter() {
        return this.mapGetter;
    }

    public void setMapGetter(Fn<? super C, ? extends Map<? super K, Object>> mapGetter) {
        this.mapGetter = mapGetter;
    }
}

