/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.util.HashMap;
import java.util.Map;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.el.PropertyELFactory;

public class CachePropertyELFactory
implements PropertyELFactory {
    private static final Map<Class, Map<String, GettingEL>> GETTER_MAP = new HashMap<Class, Map<String, GettingEL>>();
    private static final Map<Class, Map<String, EL>> SETTER_MAP = new HashMap<Class, Map<String, EL>>();
    private PropertyELFactory factory;

    public CachePropertyELFactory(PropertyELFactory factory) {
        this.factory = factory;
    }

    public GettingEL newGetter(Class clazz, String propertyName) {
        GettingEL getter = null;
        Map<String, GettingEL> map1 = GETTER_MAP.get(clazz);
        if (map1 != null) {
            getter = map1.get(propertyName);
        }
        if (getter == null) {
            getter = this.factory.newGetter(clazz, propertyName);
            if (map1 == null) {
                map1 = new HashMap<String, GettingEL>();
                GETTER_MAP.put(clazz, map1);
            }
            map1.put(propertyName, getter);
        }
        return getter;
    }

    public EL newSetter(Class clazz, String propertyName) {
        EL setter = null;
        Map<String, EL> map1 = SETTER_MAP.get(clazz);
        if (map1 != null) {
            setter = map1.get(propertyName);
        }
        if (setter == null) {
            setter = this.factory.newSetter(clazz, propertyName);
            if (map1 == null) {
                map1 = new HashMap<String, EL>();
                SETTER_MAP.put(clazz, map1);
            }
            map1.put(propertyName, setter);
        }
        return setter;
    }

    public PropertyELFactory getFactory() {
        return this.factory;
    }

    public void setFactory(PropertyELFactory factory) {
        this.factory = factory;
    }
}

