/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import woolpack.utils.DelegationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InjectiveMap<K, V>
extends DelegationMap<K, V> {
    private final Map<K, V> map;

    InjectiveMap(Map<K, V> map) {
        super(map);
        this.map = map;
        InjectiveMap.check(map);
    }

    private static <K, V> void check(Map<K, V> m) {
        if (m.values().size() != new HashSet<V>(m.values()).size()) {
            throw new IllegalStateException("value duplicate");
        }
    }

    private boolean check(K key, V value) {
        return !super.containsValue(value) || !(value == null ? super.get(key) != null : !value.equals(super.get(key)));
    }

    @Override
    public V put(K key, V value) {
        if (!this.check(key, value)) {
            throw new IllegalStateException("value duplicate: " + value);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (K key : t.keySet()) {
            V value;
            if (this.check(key, value = t.get(key))) continue;
            HashMap<K, V> tmpMap = new HashMap<K, V>(this.map);
            tmpMap.putAll(t);
            InjectiveMap.check(tmpMap);
            break;
        }
        super.putAll(t);
    }
}

