/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import woolpack.TestUtils;

import junit.framework.TestCase;

public class AddressedMessageCollectorTest extends TestCase {

	public void testNormal(){
		final AddressedMessageCollector collector = new AddressedMessageCollector();
		final ValidatorContext context = new ValidatorContext();
		context.setInputMap(new HashMap<String,List<Object>>());
		context.setCollectable(collector);

		context.setTmpKey("key0");
		context.setTmpValue("value0");
		context.add("message00");
		context.add("message01");
		context.setTmpKey("key1");
		context.setTmpValue("value1");
		context.add("message10");

		assertTrue(TestUtils.equals(Arrays.asList(
				new AddressedMessage("key0", 0, "message00", "value0"),
				new AddressedMessage("key0", 0, "message01", "value0"),
				new AddressedMessage("key1", 0, "message10", "value1"))
				, collector.getList()));
	}
}
