/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TextAllTests extends TestCase {

	public static Test suite() {
		
		TestSuite suite = new TestSuite();
		suite.addTest(new TestSuite(BooleanFormatTest.class));
		suite.addTest(new TestSuite(CloneFormatFactoryTest.class));
		suite.addTest(new TestSuite(DelegateDateFormatTest.class));
		suite.addTest(new TestSuite(DelegateNumberFormatTest.class));
		suite.addTest(new TestSuite(FixFormatTest.class));
		suite.addTest(new TestSuite(LimitedValueFormatTest.class));
		suite.addTest(new TestSuite(RegExpFormatTest.class));
		suite.addTest(new TestSuite(SwitchableFormatTest.class));
		suite.addTest(new TestSuite(ToByteFormatTest.class));
		suite.addTest(new TestSuite(ToCharacterFormatTest.class));
		suite.addTest(new TestSuite(ToDoubleFormatTest.class));
		suite.addTest(new TestSuite(ToFloatFormatTest.class));
		suite.addTest(new TestSuite(ToIntegerFormatTest.class));
		suite.addTest(new TestSuite(ToLongFormatTest.class));
		suite.addTest(new TestSuite(ToShortFormatTest.class));
		suite.addTest(new TestSuite(ToSQLDateFormatTest.class));
		suite.addTest(new TestSuite(ToStringFormatTest.class));
		return suite;
	}
}
