/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.util.Locale;

import junit.framework.TestCase;
import woolpack.dom.Count;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.FixSwitch;
import woolpack.utils.SwitchBuilder;

public class BranchByLocaleTest extends TestCase {

	public void testConstructor(){
		try{
			new BranchByLocale(null, new ThreadLocal<Locale>());
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new BranchByLocale(new FixSwitch<Locale,DomExpression>(null), null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final ThreadLocal<Locale> threadLocal = new ThreadLocal<Locale>();
		final Count counter0 = new Count(DomConstants.NULL);
		final Count counter1 = new Count(DomConstants.NULL);
		final Count counter2 = new Count(DomConstants.NULL);
		final DomExpression expression = new BranchByLocale(
				new SwitchBuilder<Locale,DomExpression>()
				.put(Locale.JAPANESE, counter0)
				.put(Locale.ENGLISH, counter1)
				.get(counter2),
				threadLocal);
		final DomContext context = new DomContext();
		
		threadLocal.set(Locale.JAPANESE);
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
		assertEquals(0, counter1.getCount());
		assertEquals(0, counter2.getCount());
		
		threadLocal.set(Locale.ENGLISH);
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
		assertEquals(1, counter1.getCount());
		assertEquals(0, counter2.getCount());
		
		threadLocal.set(Locale.CHINESE);
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
		assertEquals(1, counter1.getCount());
		assertEquals(1, counter2.getCount());
	}
}
