/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import junit.framework.TestCase;

public class MapELTest extends TestCase {

	public void testConstructor(){
		try{
			new MapEL(null, ELConstants.COLLECTION_CONVERTER);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new MapEL("", ELConstants.COLLECTION_CONVERTER);
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
		try{
			new MapEL("key0", null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testEquals(){
		{
			final MapEL obj = new MapEL("key0");
			assertTrue(obj.equals(obj));
		}
		assertEquals(new MapEL("key0"), new MapEL("key0"));
		assertFalse(new MapEL("key0").equals(new MapEL("key1")));
		assertFalse(new MapEL("key0", ELConstants.SIMPLE_CONVERTER).equals(new MapEL("key0", ELConstants.COLLECTION_CONVERTER)));
		assertFalse(new MapEL("key0").equals(new Object()));
		assertFalse(new MapEL("key0").equals(null));
	}
	
	public void testHashCode(){
		assertTrue(new MapEL("key0").hashCode() == new MapEL("key0").hashCode());
		assertTrue(new MapEL("key0").hashCode() != new MapEL("key1").hashCode());
		assertTrue(new MapEL("key0", ELConstants.SIMPLE_CONVERTER).hashCode() != new MapEL("key0", ELConstants.COLLECTION_CONVERTER).hashCode());
	}
	
	public void testToString(){
		assertEquals(
				"woolpack.el.MapEL@@[key=key0,convertEL=woolpack.el.CollectionTypeConvertEL@@[convertEL=woolpack.el.SimpleTypeConvertEL@@]]", 
				new MapEL("key0").toString().replaceAll("@[a-z0-9]+", "@@"));
	}
}
