/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import junit.framework.TestCase;

public class FixELTest extends TestCase {
	public void testNormal(){
		assertNull(new FixEL(null).getValue(null));
		assertNull(new FixEL(null).getValue(new Object()));
		assertNull(new FixEL(null).getValue(null, String.class));
		assertNull(new FixEL(null).getValue(new Object(), String.class));
		new FixEL(null).setValue(null, null);
		new FixEL(null).setValue(new Object(), new Object());

		assertEquals("value0", new FixEL("value0").getValue(null));
		assertEquals("value0", new FixEL("value0").getValue(new Object()));
		assertEquals("value0", new FixEL("value0").getValue(null, String.class));
		assertEquals("value0", new FixEL("value0").getValue(new Object(), String.class));
		new FixEL("value0").setValue(null, null);
		new FixEL("value0").setValue(new Object(), new Object());

		assertEquals(new Integer(3), new FixEL(new Integer(3)).getValue(null));
		assertEquals(new Integer(3), new FixEL(new Integer(3)).getValue(new Object()));
		assertEquals(new Integer(3), new FixEL(new Integer(3)).getValue(null, String.class));
		assertEquals(new Integer(3), new FixEL(new Integer(3)).getValue(new Object(), String.class));
		new FixEL(new Integer(3)).setValue(null, null);
		new FixEL(new Integer(3)).setValue(new Object(), new Object());
	}
	
	public void testEquals(){
		{
			final FixEL obj = new FixEL(new Integer(3));
			assertTrue(obj.equals(obj));
		}
		assertEquals(new FixEL(null), new FixEL(null));
		assertEquals(new FixEL(new Integer(3)), new FixEL(new Integer(3)));
		assertFalse(new FixEL(new Integer(3)).equals(new FixEL(new Integer(5))));
		assertFalse(new FixEL(new Integer(3)).equals(new Object()));
		assertFalse(new FixEL(new Integer(3)).equals(new FixEL(null)));
	}
	
	public void testHashCode(){
		assertTrue(new FixEL(null).hashCode() == new FixEL(null).hashCode());
		assertTrue(new FixEL(new Integer(3)).hashCode() == new FixEL(new Integer(3)).hashCode());
		assertTrue(new FixEL(new Integer(3)).hashCode() != new FixEL(new Integer(5)).hashCode());
	}
	
	public void testToString(){
		assertEquals(
				"woolpack.el.FixEL@@[value=3]", 
				new FixEL(new Integer(3)).toString().replaceAll("@[a-z0-9]+", "@@"));
	}
}
