/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.Collection;

import woolpack.utils.Switchable;

/**
 * プロパティ名で委譲先を分岐する{@link ValidatorExpression}。
 * プロパティ名に対応する値が存在しない場合は委譲しないため、
 * ブラウザから送信されない項目を無視する際に使用する。
 * @author nakamura
 *
 */
public class BranchByNameIfExistsValidator extends BranchByNameValidator{
	
	/**
	 * コンストラクタ。
	 * @param validatorIterable 値検証一覧の呼び出し方。
	 * @param switchable プロパティ名と{@link ValidatorExpression}の{@link ValidatorIterable}。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public BranchByNameIfExistsValidator(final ValidatorIterable validatorIterable, final Switchable<String,ValidatorExpression> switchable){
		super(validatorIterable, switchable);
	}
	
	/**
	 * コンストラクタ。値検証一覧の呼び出し方は{@link ValidatorConstants#AND}を使用する。
	 * @param switchable プロパティ名と{@link ValidatorExpression}の{@link Switchable}。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public BranchByNameIfExistsValidator(final Switchable<String,ValidatorExpression> switchable){
		this(ValidatorConstants.AND, switchable);
	}
	
	@Override protected Collection<String> keySet(final ValidatorContext context){
		return context.getInputMap().keySet();
	}
}
