/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;

/**
 * 文字列を解析して{@link Float}に変換する変換器。
 * {@link #parse(String, ParsePosition)}では一度値を double 型で取得して float 型に変換するため、丸め誤差が発生する可能性がある。
 * @author nakamura
 *
 */
public class ToFloatFormat extends DelegateNumberFormat {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * コピーコンストラクタ。
	 * {@link #clone()}から呼び出される(called)。
	 * @param format コピー元。
	 * @param dummy ダミー。
	 */
	protected ToFloatFormat(final ToFloatFormat format, final boolean dummy){
		super(format, dummy);
	}
	
	/**
	 * コンストラクタ。
	 * @param format 数値変換の委譲先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public ToFloatFormat(final NumberFormat format){
		super(format);
	}

	/**
	 * コンストラクタ。
	 * {@link DecimalFormat}を数値変換の委譲先とする。
	 */
	public ToFloatFormat(){
		super();
	}

	@Override
	public Number parse(final String source, final ParsePosition parsePosition) {
		final Number n = super.parse(source, parsePosition);
		if(n != null){
			return new Float(n.floatValue());
		}
		return null;
	}

	@Override public Object clone(){
		return new ToFloatFormat(this, false);
	}
}
