/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import org.w3c.dom.Node;

import woolpack.el.GettingEL;


/**
 * 指定された DOM ノードをテキストノードに置き換える{@link DomExpression}。
 * コンテキストから取得した値が null の場合は値を更新しない。
 * @author nakamura
 *
 */
public class ReplaceText implements DomExpression {
	private final GettingEL valueEL;
	
	/**
	 * コンストラクタ。
	 * @param valueEL 置き換える文字列の取得先への参照。コンテキスト役に対して副作用が発生すべきではない。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public ReplaceText(final GettingEL valueEL){
		valueEL.getClass();
		this.valueEL = valueEL;
	}

	/**
	 * @throws NullPointerException 引数または{@link DomContext#getNode()}または取得した文字列が null の場合。
	 */
	public void interpret(DomContext context) {
		final Node node = context.getNode();
		final String value = (String)valueEL.getValue(context, String.class);
		if(value != null){
			node.getParentNode().insertBefore(DomConstants.getDocumentNode(node).createTextNode(value), node);
			DomConstants.removeThis(node);
		}
	}
}
