/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/**
 * クライアント値検証のオンオフを切り替えるフラグ。
 */
var validator_flag = true;

/**
 * クライアント(ウェブブラウザ)で値検証をするためには、
 * {@link woolpack.validator.ValidatorExpression#appendTo(Appendable)}
 * で生成された文字列で値を置き換え、必要な HTML ファイルからこのファイルを参照する。
 */
var validator_tree = new BranchByIdValidator({
	"id0":new BranchByNameValidator(new AndValidatorIterable(),{
		"key0":new SerialValidator(new AndAndValidatorIterable(),[
			new IfNotValidator(new RequiredValidator(), new MessageValidator("key0 required")),
			new IfNotValidator(new MinLengthValidator(2), new MessageValidator("key0 min length")),
			new IfNotValidator(new MaxLengthValidator(4), new MessageValidator("key0 max length"))
		]),
		"key1":new SerialValidator(new AndAndValidatorIterable(),[
			new IfNotValidator(new RequiredValidator(), new MessageValidator("key1 required")),
			new IfNotValidator(new MinLengthValidator(3), new MessageValidator("key1 min length")),
			new IfNotValidator(new MaxLengthValidator(5), new MessageValidator("key1 max length"))
		])
	}),
	"id1":new BranchByNameValidator(new AndValidatorIterable(),{
		"key0":new SerialValidator(new AndAndValidatorIterable(),[
			new IfNotValidator(new RequiredValidator(), new MessageValidator("key0 required")),
			new IfNotValidator(new MinLengthValidator(4), new MessageValidator("key0 min length")),
			new IfNotValidator(new MaxLengthValidator(6), new MessageValidator("key0 max length"))
		]),
		"key1":new SerialValidator(new AndAndValidatorIterable(),[
			new IfNotValidator(new RequiredValidator(), new MessageValidator("key1 required")),
			new IfNotValidator(new MinLengthValidator(5), new MessageValidator("key1 min length")),
			new IfNotValidator(new MaxLengthValidator(7), new MessageValidator("key1 max length"))
		])
	})
});

/**
 * 値検証を行い結果をダイアログに表示するサンプル実装。
 * 値検証結果のメッセージを加工(変換)したり
 * 値検証結果を表示する位置を変更したりするには
 * このサンプルを変更する必要がある。
 */
function checkAndAlert(form){
	if(!validator_flag){
		return true;
	}
	var id = form.getAttribute("action");
	id = id.replace("(.+)\\.[^\\.]+", "$1");
	
	var context = new ValidatorContext();
	context.collectable = new SimpleMessageCollector();
	context.id = id;
	context.inputMap = convertFormToListMap(form);
	var flag = validator_tree.interpret(context);
	if(!flag){
		var sb = "";
		for(var i in context.collectable.messageList){
			sb = sb + "\n" + context.collectable.messageList[i];
		}
		alert(sb);
	}
	return flag;
}
