/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.ui.view.SingleResultSetView;
import hiro.yoshioka.ui.view.internal.SimaPureViewer;
import hiro.yoshioka.wolfdbmanager.Application;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.eclipse.swt.widgets.Composite;

public class ResultSetView
extends SingleResultSetView {
    public static final String ID = "ResultSetViewID";
    private SimaPureViewer fViewer;
    Calendar c = Calendar.getInstance();
    private boolean isFirstView = true;

    public String gettR() {
        return String.format("%tR", this.c);
    }

    public SimaPureViewer getViewer() {
        return this.fViewer;
    }

    @Override
    public int[] getSelectionIndices() {
        return this.fViewer.getSelectionIndices();
    }

    public void dispose() {
        this.resetResultSetLists();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.fViewer = new SimaPureViewer(parent, PreferenceUtil.getBoolean("BOOLEAN_VIEWER_SWING"), false, false);
    }

    public void setInput(Request t_request) {
        this.setInput((ResultSetDataHolder)t_request.getRdh(), t_request.getConnectionProperties());
    }

    public void setInput(ResultSetDataHolder rdh, ConnectionProperties connectionProperties) {
        this.fResultSetDataHolder = (ResultSetDataHolder2)rdh;
        if (connectionProperties == null) {
            this.log.info((Object)"reference only...");
        } else {
            this.setConnectionPropertiesDisplay(connectionProperties.getDisplayString());
        }
        if (rdh == null) {
            this.fViewer.setInput(null, true);
            return;
        }
        if (this.fResultSetDataHolder.isForUpdate()) {
            int i = 0;
            while (i < 10) {
                this.fResultSetDataHolder.addRow(null);
                this.fResultSetDataHolder.addRow(null);
                this.fResultSetDataHolder.addRow(null);
                this.fResultSetDataHolder.addRow(null);
                this.fResultSetDataHolder.addRow(null);
                ++i;
            }
        }
        System.out.println("isFirst=" + this.isFirstView);
        System.out.println("fResultSetDataHolder.isForUpdate()=" + this.fResultSetDataHolder.isForUpdate());
        if (this.isFirstView) {
            boolean isChecked = PreferenceUtil.getBoolean("BOOLEAN_DEFAULT_COLUMN_ADJUST_COLUMN");
            this.fViewer.setInput((ResultSetDataHolder)this.fResultSetDataHolder, isChecked);
            this.isFirstView = false;
        } else {
            this.fViewer.setInput((ResultSetDataHolder)this.fResultSetDataHolder, false);
        }
        Application.setEnableAction(this, "ResultSetReflectActionID", this.fResultSetDataHolder.isForUpdate());
        Application.setEnableAction(this, "ResultSet2InsertScriptID", this.fResultSetDataHolder.hasResultSetMetaData());
        Application.setStatus("estimatedTime[" + this.fResultSetDataHolder.getFormattedWrapTime() + "sec]");
        this.resetResultSetLists();
    }

    public void setFocus() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"focus in");
        }
        this.fViewer.setFocus();
    }

    public void serialize(File fname) {
        try {
            PreferenceUtil.save(fname, this.fResultSetDataHolder);
        }
        catch (IOException e) {
            this.log.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void adjustDatum() {
        this.fViewer.adjustDatum();
    }

    @Override
    public void adjustHeader() {
        this.fViewer.adjustHeader();
    }

    @Override
    public void adjustArea() {
        this.fViewer.adjustArea();
    }

    @Override
    public void selectAll() {
        this.fViewer.selectAll();
    }

    @Override
    void lostFocus() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"focus lost");
        }
        this.fViewer.cancelEditing();
    }
}

