/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.ast.sql.util.ASTFormatingInfo;
import hiro.yoshioka.ast.sql.util.ParserFactory;
import hiro.yoshioka.ast.sql.util.ParserUtil;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.ui.action.AbsWorkbenchSQLEditorAction;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;

public class FormatAction
extends AbsWorkbenchSQLEditorAction {
    public FormatAction(int style) {
        super(style);
        this.setEnabled(false);
        this.setId("Wolf.format");
        this.setActionDefinitionId("Wolf.format");
    }

    @Override
    public void update() {
        Application.exec(new Runnable(){

            @Override
            public void run() {
                String targetString = Application.getActiveSQLEditorInput();
                if (targetString == null || targetString.trim().length() == 0) {
                    FormatAction.this.setEnabled(false);
                } else {
                    FormatAction.this.setEnabled(true);
                }
            }
        });
    }

    @Override
    public void execute(SQLEditor editor, ConnectionProperties p) throws Exception {
        String targetString = editor.getText();
        try {
            targetString = targetString.replaceAll("\t", "  ");
            String input = StringUtil.resetCRLF((String)targetString, (boolean)false);
            ParserFactory factory = ParserFactory.createFactory((String)p.getDatabaseType().getDriverName());
            ParserUtil util = factory.createParserUtil(input);
            ASTFormatingInfo info = PreferenceUtil.getFormatterInfo(input);
            util.parse();
            input = util.getFormattedString(info);
            ((SQLEditor)this.fIWorkbenchPage.getActiveEditor()).setText(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

