/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.ui.editor.action;

import hiro.yoshioka.ast.sql.util.IProposalableParserUtil;
import hiro.yoshioka.preferences.PreferenceUtil;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.sql.ui.editor.action.Messages;
import hiro.yoshioka.sql.util.GeneralTableShowRequest;
import hiro.yoshioka.ui.action.AbsWorkbenchSQLEditorAction;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;

public class ExecuteDropDownAction
extends AbsWorkbenchSQLEditorAction {
    public ExecuteDropDownAction() {
        super(1);
        this.setText(Messages.getString("ExecuteDropDownAction.Execution"));
        this.setImageDescriptor(ImageManager.getImageDescriptor("action/60execute.gif"));
        this.setEnabled(false);
        this.setId("Wolf.execute");
        this.setActionDefinitionId("Wolf.execute");
    }

    @Override
    public void execute(SQLEditor editor, ConnectionProperties p) throws Exception {
        IProposalableParserUtil util = editor.getUtil(true);
        TransactionRequest req = util.createTransactionRequest(p);
        if (req == null) {
            return;
        }
        req.setMaxRownum(editor.getMaxRowNum());
        req.setScription(PreferenceUtil.getExternalJars(), ResourceMarker.getScriptFolder());
        req.setPartName(Application.getActiveSQLEditor().getTitle());
        GeneralTableShowRequest tr = new GeneralTableShowRequest(req, editor.isCanUpdatableMode());
        try {
            tr.fIDBTable = util.getFirstTable();
        }
        catch (Exception e) {
            this.fLogger.warn((Object)"", (Throwable)e);
        }
        req.addListener((IRequestListener)tr);
        req.setTimeOut(PreferenceUtil.getInt("SQL_TIMEOUT_NUM"));
        SQLServerThread.putRequest((Request)req);
        this.setEnabled(true);
    }
}

