/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.ui.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;

public class SQL2JavaStringAction
extends Action {
    public static final String LINE_SEPARATOR = System.getProperties().getProperty("line.separator");
    Pattern P = Pattern.compile("\"(.*)\"");
    Pattern P2 = Pattern.compile("(\r\n)|(\r)|(\n)");
    IDocument document;
    boolean sql2java;

    public SQL2JavaStringAction(IDocument document, boolean sql2java) {
        if (sql2java) {
            this.setText("SQL2Java");
        } else {
            this.setText("Java2SQL");
        }
        this.document = document;
        this.sql2java = sql2java;
    }

    public void run() {
        StringBuffer buf = new StringBuffer();
        if (this.sql2java) {
            String[] lines = this.document.get().split("[\r\n]+");
            int i = 0;
            while (i < lines.length) {
                String hen = lines[i].replaceAll("[\"]", "\\\\\"");
                if (i == lines.length - 1) {
                    buf.append(String.format("\" %-80s\";%s", hen, LINE_SEPARATOR));
                } else {
                    buf.append(String.format("\" %-80s\"+%s", hen, LINE_SEPARATOR));
                }
                ++i;
            }
        } else {
            Matcher m = this.P.matcher(this.document.get());
            int i = 0;
            while (m.find()) {
                String hen = m.group(1).replaceAll("\\\\\"", "\"");
                if (i > 0) {
                    buf.append(LINE_SEPARATOR);
                }
                buf.append(hen);
                ++i;
            }
        }
        this.document.set(buf.toString());
    }
}

