/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.preferences.Messages;
import hiro.yoshioka.sdh.RDHTableContentProvider;
import hiro.yoshioka.sdh.StringRecordDataHolder;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.ui.view.SingleResultSetView;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class CompareDialog
extends TitleAreaDialog {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    static final String COMPARE_FROM = Messages.CompareDialog_CompareFrom;
    static final String COMPARE_TO = Messages.CompareDialog_ComprareTo;
    int[] fCheckIndexes;
    String fLeftTableName;
    String fRightTableName;
    CheckboxTableViewer fLeftTableViewer;
    CheckboxTableViewer fRightTableViewer;
    CLabel fLeftLabel;
    CLabel fRightLabel;
    SingleResultSetView[] fInputData;

    public CompareDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.CompareDialog_CheckKey);
        SashForm MainComposite = new SashForm(composite, 256);
        GridData data2 = new GridData(1808);
        MainComposite.setLayoutData((Object)data2);
        Composite leftComposite = new Composite((Composite)MainComposite, 0);
        Composite rightComposite = new Composite((Composite)MainComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        leftComposite.setLayout((Layout)layout);
        leftComposite.setLayoutData((Object)new GridData(1808));
        rightComposite.setLayout((Layout)layout);
        rightComposite.setLayoutData((Object)new GridData(1808));
        this.fLeftLabel = this.createTable(leftComposite, COMPARE_FROM);
        this.fLeftLabel.setText(this.fInputData[0].getPartName());
        this.fRightLabel = this.createTable(rightComposite, COMPARE_TO);
        this.fRightLabel.setText(this.fInputData[1].getPartName());
        return composite;
    }

    CLabel createTable(Composite composite, String tips) {
        CLabel list = new CLabel(composite, 2048);
        try {
            list.setToolTipText(tips);
            GridData data = new GridData(768);
            list.setLayoutData((Object)data);
            Table table = new Table(composite, 34);
            data = new GridData(1808);
            table.setLayoutData((Object)data);
            CheckboxTableViewer viewer = new CheckboxTableViewer(table);
            viewer.setContentProvider((IContentProvider)new MyRDHTableContentProvider());
            viewer.setInput(null);
            if (tips == COMPARE_FROM) {
                this.fLeftTableViewer = viewer;
                this.set1(viewer, 0);
            } else {
                this.fRightTableViewer = viewer;
                this.set1(viewer, 1);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void set1(CheckboxTableViewer viewer, int idx) {
        String tablename = this.fInputData[idx].getInput().getTableNameE();
        viewer.setInput((Object)this.fInputData[idx].getInput());
        try {
            ConnectionProperties p;
            IDBTable itbl;
            if (tablename != null && tablename.length() > 0 && (itbl = (p = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(this.fInputData[idx].getConnectionPropertiesDisplay())).getDBRootResource().getDefaultSchema().getTableResource(tablename)) != null) {
                IDBColumn[] columns = itbl.getColumns();
                ArrayList<String> pk_list = new ArrayList<String>();
                int i = 0;
                while (i < columns.length) {
                    if (columns[i].isPkey()) {
                        pk_list.add(columns[i].getName());
                        pk_list.add(columns[i].getComment());
                    }
                    ++i;
                }
                this.setCheckedElements(viewer, pk_list);
            }
        }
        catch (RuntimeException e) {
            this.fLogger.warn((Object)"", (Throwable)e);
        }
    }

    private void setCheckedElements(CheckboxTableViewer viewer, ArrayList<String> pk_list) {
        TableItem[] items = viewer.getTable().getItems();
        int ii = 0;
        while (ii < pk_list.size()) {
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                Object element = item.getData();
                if (element != null && element.toString().equalsIgnoreCase(pk_list.get(ii))) {
                    item.setChecked(true);
                }
                ++i;
            }
            ++ii;
        }
    }

    public int[] getCheckIndexes() {
        return this.fCheckIndexes;
    }

    protected void okPressed() {
        TableItem[] children = this.fLeftTableViewer.getTable().getItems();
        int size = 0;
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (item.getChecked()) {
                ++size;
            }
            ++i;
        }
        this.fCheckIndexes = new int[size];
        i = 0;
        int j = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (item.getChecked()) {
                this.fCheckIndexes[j++] = i;
            }
            ++i;
        }
        super.okPressed();
    }

    public void configure(SingleResultSetView[] rdh) {
        this.fInputData = rdh;
    }

    public String getLeftName() {
        return this.fLeftTableName;
    }

    public String getRightName() {
        return this.fRightTableName;
    }

    class MyRDHTableContentProvider
    extends RDHTableContentProvider {
        MyRDHTableContentProvider() {
        }

        public Object[] getElements(Object element) {
            return ((StringRecordDataHolder)element).getKey();
        }
    }
}

