/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.job.ResultSetExcelWriter;
import hiro.yoshioka.sdh.diff.DiffToResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DiffResultSetExcelWriter
extends ResultSetExcelWriter {
    List<DiffToResultSetDataHolder> structList = new ArrayList<DiffToResultSetDataHolder>();
    List<DiffToResultSetDataHolder> valueList = new ArrayList<DiffToResultSetDataHolder>();
    String displayName;
    String targetDisplayName;
    int summaryRow = 3;

    public DiffResultSetExcelWriter(DiffToResultSetDataHolder[] drhs, String displayName, String targetDisplayName, File savefile) {
        super(null, savefile);
        ResultSetDataHolder2[] fResultSetDataHolder1 = new ResultSetDataHolder2[drhs.length];
        ResultSetDataHolder2[] fResultSetDataHolder2 = new ResultSetDataHolder2[drhs.length];
        this.remarks = new String[drhs.length];
        int i = 0;
        while (i < drhs.length) {
            fResultSetDataHolder1[i] = (ResultSetDataHolder2)drhs[i].getLeftTarget();
            fResultSetDataHolder2[i] = (ResultSetDataHolder2)drhs[i].getRightTarget();
            this.remarks[i] = drhs[i].getDiffInfomation();
            ++i;
        }
        this.displayName = displayName;
        this.targetDisplayName = targetDisplayName;
        this.fResultSetDataHolder = fResultSetDataHolder1;
        this.fCompareResultSetDataHolder = fResultSetDataHolder2;
        this.supportDiff = true;
        DiffToResultSetDataHolder[] diffToResultSetDataHolderArray = drhs;
        int n = drhs.length;
        int n2 = 0;
        while (n2 < n) {
            DiffToResultSetDataHolder drh = diffToResultSetDataHolderArray[n2];
            if (drh.getRemarks().isStruct()) {
                this.structList.add(drh);
            } else {
                this.valueList.add(drh);
            }
            ++n2;
        }
    }

    private void write_sub(HSSFSheet sheet, String title, List<DiffToResultSetDataHolder> drhList) {
        HSSFCell cell = null;
        cell = this.createHSSFCell(sheet, (short)2, this.summaryRow);
        cell.setCellValue(title);
        ++this.summaryRow;
        String[] titles = new String[]{"NO", "Display1", "Display2", "Table", "numOfUpdate", "numOfInsert", "numOfDelete"};
        int i = 0;
        while (i < titles.length) {
            cell = this.createHSSFCell(sheet, (short)(i + 2), this.summaryRow);
            cell.setCellValue(titles[i]);
            cell.setCellStyle(this.styleHeader);
            ++i;
        }
        int sumUpdate = 0;
        int sumInsert = 0;
        int sumDelete = 0;
        int j = 0;
        while (j < drhList.size()) {
            DiffToResultSetDataHolder drh = drhList.get(j);
            ++this.summaryRow;
            cell = this.createHSSFCell(sheet, "C", this.summaryRow);
            cell.setCellValue((double)(j + 1));
            cell.setCellStyle(this.styleBordered);
            cell = this.createHSSFCell(sheet, "D", this.summaryRow);
            cell.setCellValue(this.displayName);
            cell.setCellStyle(this.styleBordered);
            cell = this.createHSSFCell(sheet, "E", this.summaryRow);
            cell.setCellValue(this.targetDisplayName);
            cell.setCellStyle(this.styleBordered);
            ResultSetDataHolder2 rdh = (ResultSetDataHolder2)drh.getLeftTarget();
            cell = this.createHSSFCell(sheet, "F", this.summaryRow);
            cell.setCellValue(rdh.getTableNameE());
            cell.setCellStyle(this.styleBordered);
            cell = this.createHSSFCell(sheet, "G", this.summaryRow);
            cell.setCellValue((double)drh.getSumUpdate());
            cell.setCellStyle(this.styleBordered);
            sumUpdate += drh.getSumUpdate();
            cell = this.createHSSFCell(sheet, "H", this.summaryRow);
            cell.setCellValue((double)drh.getSumInsert());
            cell.setCellStyle(this.styleBordered);
            sumInsert += drh.getSumInsert();
            cell = this.createHSSFCell(sheet, "I", this.summaryRow);
            cell.setCellValue((double)drh.getSumDelete());
            cell.setCellStyle(this.styleBordered);
            sumDelete += drh.getSumDelete();
            ++j;
        }
        ++this.summaryRow;
        cell = this.createHSSFCell(sheet, "F", this.summaryRow);
        cell.setCellValue("TOTAL");
        cell.setCellStyle(this.styleHeader);
        cell = this.createHSSFCell(sheet, "G", this.summaryRow);
        cell.setCellValue((double)sumUpdate);
        cell.setCellStyle(this.styleBordered);
        cell = this.createHSSFCell(sheet, "H", this.summaryRow);
        cell.setCellValue((double)sumInsert);
        cell.setCellStyle(this.styleBordered);
        cell = this.createHSSFCell(sheet, "I", this.summaryRow);
        cell.setCellValue((double)sumDelete);
        cell.setCellStyle(this.styleBordered);
    }

    @Override
    public IStatus write(IProgressMonitor monitor) {
        this.fLogger.trace((Object)"start");
        try {
            int sum = 0;
            this.fLogger.trace((Object)("fResultSetDataHolder == null ? " + (this.fResultSetDataHolder == null)));
            int i = 0;
            while (i < this.fResultSetDataHolder.length) {
                sum += this.fResultSetDataHolder[i].getKey().length;
                ++i;
            }
            this.fLogger.trace((Object)("fCompareResultSetDataHolder == null ? " + (this.fCompareResultSetDataHolder == null)));
            i = 0;
            while (this.fCompareResultSetDataHolder != null && i < this.fCompareResultSetDataHolder.length) {
                sum += this.fCompareResultSetDataHolder[i].getKey().length;
                ++i;
            }
            HSSFSheet sheet = null;
            sheet = this.fHSSFWorkbook.createSheet("Summary");
            sheet.getPrintSetup().setPaperSize((short)9);
            int[] titles_size = new int[]{20, 60, 60, 140, 70, 70, 70};
            sheet.setColumnWidth(0, 65);
            sheet.setColumnWidth(1, 65);
            int i2 = 0;
            while (i2 < titles_size.length) {
                sheet.setColumnWidth(i2 + 2, 65 * titles_size[i2]);
                ++i2;
            }
            if (this.structList.size() > 0) {
                this.write_sub(sheet, "Difference in structure(DDL)", this.structList);
                ++this.summaryRow;
            }
            if (this.valueList.size() > 0) {
                this.write_sub(sheet, "Difference in table values", this.valueList);
            }
            this.fLogger.trace((Object)"EXCEL-FileOutput");
            monitor.beginTask("Generate EXCEL", sum);
            if (this.write_sub(this.fResultSetDataHolder, monitor) == Status.CANCEL_STATUS) {
                this.fLogger.trace((Object)"cancelllllllllllllllllllllllll");
                return Status.CANCEL_STATUS;
            }
            if (this.fCompareResultSetDataHolder != null && this.write_sub(this.fCompareResultSetDataHolder, monitor) == Status.CANCEL_STATUS) {
                return Status.CANCEL_STATUS;
            }
            this.save(this.fSaveFile);
        }
        catch (Exception e) {
            this.fLogger.error((Object)e);
            e.printStackTrace();
        }
        this.fLogger.trace((Object)"end");
        return Status.OK_STATUS;
    }
}

