/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.tabbedview;

import hiro.yoshioka.gef.tabbedview.ButtonElement;
import hiro.yoshioka.gef.tabbedview.ButtonElementProperties;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class FontSection
extends AbstractPropertySection {
    Text fontText;
    private ButtonElement buttonElement;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        System.out.println("selection=" + selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof ButtonElement));
        this.buttonElement = (ButtonElement)input;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 5;
        gc.dispose();
        shell.dispose();
        CLabel fontLabel = this.getWidgetFactory().createCLabel(composite, "Font:");
        this.fontText = this.getWidgetFactory().createText(composite, "");
        this.fontText.setEditable(false);
        Button fontButton = this.getWidgetFactory().createButton(composite, "Change...", 8);
        fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontData fData;
                FontDialog ftDialog = new FontDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                FontData fontdata = FontSection.this.buttonElement.getControl().getFont().getFontData()[0];
                String value = fontdata.toString();
                if (value != null && value.length() > 0) {
                    ftDialog.setFontList(new FontData[]{new FontData(value)});
                }
                if ((fData = ftDialog.open()) != null) {
                    value = fData.toString();
                    ButtonElementProperties properties = (ButtonElementProperties)FontSection.this.buttonElement.getAdapter(IPropertySource.class);
                    properties.setPropertyValue("font", value);
                    FontSection.this.fontText.setText(StringConverter.asString((FontData)fData));
                }
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fontText, -5);
        data.top = new FormAttachment(0, 0);
        fontLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment((Control)fontButton, -5);
        data.top = new FormAttachment(0, 0);
        this.fontText.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.height = buttonHeight;
        fontButton.setLayoutData((Object)data);
    }

    public void refresh() {
        FontData fontdata = this.buttonElement.getControl().getFont().getFontData()[0];
        this.fontText.setText(StringConverter.asString((FontData)fontdata));
    }
}

