/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.yaml.dom;

import hiro.yoshioka.yaml.dom.IYamlElement;
import hiro.yoshioka.yaml.dom.IYamlMapElement;
import hiro.yoshioka.yaml.dom.ScriptElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbsYamlElement
implements IYamlElement {
    private static final IYamlElement[] EMPTY_ELEMENTS = new IYamlElement[0];
    private static final IYamlMapElement[] EMPTY_MAP_ELEMENTS = new IYamlMapElement[0];
    List<IYamlElement> childList;
    String title;
    ScriptElement scriptElement;
    IYamlElement parent;

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IYamlElement getParent() {
        return this.parent;
    }

    @Override
    public IYamlElement[] getChildren() {
        if (this.hasChild()) {
            return this.childList.toArray(new IYamlElement[this.childList.size()]);
        }
        return EMPTY_ELEMENTS;
    }

    @Override
    public IYamlElement getFirstChildOf(String name) {
        if (this.hasChild()) {
            for (IYamlElement child : this.childList) {
                if (!(child instanceof IYamlMapElement) || !((IYamlMapElement)child).getKey().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    @Override
    public IYamlMapElement[] getMapChildren() {
        if (this.hasChild()) {
            List<IYamlMapElement> ret = this.getMapChildList();
            return ret.toArray(new IYamlMapElement[ret.size()]);
        }
        return EMPTY_MAP_ELEMENTS;
    }

    @Override
    public List<IYamlElement> getChildList() {
        if (this.hasChild()) {
            return this.childList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<IYamlMapElement> getMapChildList() {
        if (this.hasChild()) {
            ArrayList<IYamlMapElement> retList = new ArrayList<IYamlMapElement>();
            for (IYamlElement c : this.childList) {
                if (!(c instanceof IYamlMapElement)) continue;
                retList.add((IYamlMapElement)c);
            }
            return retList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean hasChild() {
        return this.childList != null && this.childList.size() > 0;
    }

    @Override
    public String getLabelString() {
        return String.format("TITLE[%s] ", this.title);
    }

    @Override
    public void addChild(IYamlElement yamlElement) {
        if (this.childList == null) {
            this.childList = new ArrayList<IYamlElement>();
        }
        this.childList.add(yamlElement);
        ((AbsYamlElement)yamlElement).parent = this;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public ScriptElement getScriptElement() {
        if (this.hasScriptElement()) {
            this.scriptElement.iFile = this.getIFile();
        }
        return this.scriptElement;
    }

    @Override
    public boolean hasScriptElement() {
        return this.scriptElement != null;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    void setScript(String scriptText) {
        if (!this.hasScriptElement()) {
            this.scriptElement = new ScriptElement();
        }
        this.scriptElement.setScriptText(scriptText);
    }

    void setScriptEngineName(String engineName) {
        if (!this.hasScriptElement()) {
            this.scriptElement = new ScriptElement();
        }
        this.scriptElement.setEngineName(engineName);
    }
}

