/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.Collection;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IMasterPageEventHandler;
import org.eclipse.birt.report.engine.api.script.eventhandler.IReportEventHandler;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.instance.PageInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageScriptExecutor
extends ScriptExecutor {
    protected static boolean needOnPageStart(MasterPageDesign masterPage) {
        return masterPage.getOnPageStart() != null || masterPage.getJavaClass() != null;
    }

    protected static boolean needOnPageEnd(MasterPageDesign masterPage) {
        return masterPage.getOnPageEnd() != null || masterPage.getJavaClass() != null;
    }

    private static IMasterPageEventHandler getEventHandler(MasterPageDesign masterPage, ExecutionContext context) {
        try {
            return (IMasterPageEventHandler)PageScriptExecutor.getInstance(masterPage.getJavaClass(), context);
        }
        catch (ClassCastException e) {
            PageScriptExecutor.addClassCastException(context, e, masterPage.getHandle(), IReportEventHandler.class);
        }
        catch (EngineException e) {
            PageScriptExecutor.addException(context, (Exception)((Object)e), masterPage.getHandle());
        }
        return null;
    }

    public static void handleOnPageEndScript(ExecutionContext context, PageContent pageContent, Collection<IContent> contents) {
        MasterPageDesign masterPage = (MasterPageDesign)pageContent.getGenerateBy();
        if (masterPage != null) {
            try {
                if (!PageScriptExecutor.needOnPageEnd(masterPage)) {
                    return;
                }
                PageInstance pageInstance = new PageInstance(context, pageContent, contents);
                if (PageScriptExecutor.handleScript(pageInstance, masterPage.getOnPageEnd(), context).didRun()) {
                    return;
                }
                IMasterPageEventHandler eh = PageScriptExecutor.getEventHandler(masterPage, context);
                if (eh != null) {
                    eh.onPageEnd(pageInstance, context.getReportContext());
                }
            }
            catch (Exception e) {
                PageScriptExecutor.addException(context, e, masterPage.getHandle());
            }
        }
    }

    public static void handleOnPageStartScript(ExecutionContext context, PageContent pageContent, Collection<IContent> contents) {
        MasterPageDesign masterPage = (MasterPageDesign)pageContent.getGenerateBy();
        if (masterPage != null) {
            try {
                if (!PageScriptExecutor.needOnPageStart(masterPage)) {
                    return;
                }
                PageInstance pageInstance = new PageInstance(context, pageContent, contents);
                if (PageScriptExecutor.handleScript(pageInstance, masterPage.getOnPageStart(), context).didRun()) {
                    return;
                }
                IMasterPageEventHandler eh = PageScriptExecutor.getEventHandler(masterPage, context);
                if (eh != null) {
                    eh.onPageStart(pageInstance, context.getReportContext());
                }
            }
            catch (Exception e) {
                PageScriptExecutor.addException(context, e, masterPage.getHandle());
            }
        }
    }
}

