/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ResultMetaData
implements IResultMetaData {
    IResultClass m_odiResultClass;
    protected static Logger logger = Logger.getLogger(ResultMetaData.class.getName());
    private int columnCount = -1;

    public ResultMetaData(IResultClass odiResultClass) {
        logger.entering(ResultMetaData.class.getName(), "ResultMetaData", odiResultClass);
        assert (odiResultClass != null);
        this.m_odiResultClass = odiResultClass;
        logger.logp(Level.FINER, QueryResults.class.getName(), "QueryResults", "QueryResults starts up");
        logger.exiting(ResultMetaData.class.getName(), "ResultMetaData");
    }

    public int getColumnCount() {
        logger.logp(Level.FINEST, QueryResults.class.getName(), "getColumnCount", "");
        return this.doGetColumnCount();
    }

    private int doGetColumnCount() {
        int columnCount;
        if (this.columnCount != -1) {
            return this.columnCount;
        }
        int i = columnCount = this.m_odiResultClass.getFieldCount();
        while (i > 0) {
            try {
                if (!this.isTemp(this.m_odiResultClass.getFieldName(i))) {
                    columnCount = i;
                    break;
                }
            }
            catch (DataException dataException) {
                return columnCount;
            }
            --i;
        }
        return columnCount;
    }

    private boolean isTemp(String name) {
        return name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E");
    }

    public String getColumnName(int index) throws DataException {
        this.checkIndex(index);
        logger.logp(Level.FINEST, QueryResults.class.getName(), "getColumnName", "the column name at the specified index", index);
        return this.m_odiResultClass.getFieldName(index);
    }

    public String getColumnAlias(int index) throws DataException {
        this.checkIndex(index);
        logger.logp(Level.FINEST, QueryResults.class.getName(), "getColumnAlias", "the column alias at the specified index", index);
        return this.m_odiResultClass.getFieldAlias(index);
    }

    public int getColumnType(int index) throws DataException {
        this.checkIndex(index);
        logger.logp(Level.FINEST, QueryResults.class.getName(), "getColumnType", "the data type of the column at the specified index", index);
        Class odiDataType = this.m_odiResultClass.getFieldValueClass(index);
        return DataTypeUtil.toApiDataType((Class)odiDataType);
    }

    public String getColumnTypeName(int index) throws DataException {
        this.checkIndex(index);
        logger.logp(Level.FINEST, QueryResults.class.getName(), "getColumnTypeName", "the Data Engine data type name of the column at the specified index", index);
        return DataType.getName((int)this.getColumnType(index));
    }

    public String getColumnNativeTypeName(int index) throws DataException {
        this.checkIndex(index);
        logger.logp(Level.FINEST, QueryResults.class.getName(), "getColumnNativeTypeName", "the data provider specific data type name of the specified column", index);
        return this.m_odiResultClass.getFieldNativeTypeName(index);
    }

    public String getColumnLabel(int index) throws DataException {
        this.checkIndex(index);
        logger.logp(Level.FINEST, QueryResults.class.getName(), "getColumnLabel", "the label or display name of the column at the specified index", index);
        return this.m_odiResultClass.getFieldLabel(index);
    }

    public boolean isComputedColumn(int index) throws DataException {
        this.checkIndex(index);
        logger.logp(Level.FINEST, QueryResults.class.getName(), "isComputedColumn", "whether the specified projected column is defined as a computed column", index);
        return this.m_odiResultClass.isCustomField(index);
    }

    private void checkIndex(int index) throws DataException {
        if (index > this.doGetColumnCount()) {
            throw new DataException("data.engine.InvalidFieldIndex", index);
        }
    }
}

