/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import java.net.URL;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkerSupportInternalUtilities {
    static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_FILTER_CLASS = "filterClass";
    private static final String ATTRIBUTE_FILTER_CONFIGURATION_CLASS = "filterConfigurationClass";
    public static final String ATTRIBUTE_ICON = "icon";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_TYPE = "type";
    static final Object CONTAINS_MODIFIER_TOKEN = new Object();
    static final Object CONTAINS_TEXT_TOKEN = new Object();
    static final CollationKey EMPTY_COLLATION_KEY = Collator.getInstance().getCollationKey("");
    static final IMarker[] EMPTY_MARKER_ARRAY = new IMarker[0];
    static final MarkerSupportItem[] EMPTY_MARKER_ITEM_ARRAY = new MarkerSupportItem[0];
    static final IResource[] EMPTY_RESOURCE_ARRAY = new IResource[0];
    public static final String EMPTY_STRING = "";
    public static final String UNKNOWN_ATRRIBTE_VALUE_STRING = MarkerMessages.Unknown;
    static final String FALSE = "false";
    public static final String IMG_MARKERS_HELP_DECORATION_PATH = "markers/help_small.gif";
    public static final String IMG_MARKERS_QUICK_FIX_DECORATION_PATH = "markers/contassist_ovr.gif";
    public static final String LEGACY_SUFFIX = ".old";
    public static final String MIGRATE_PREFERENCE_CONSTANT = "_MIGRATE";
    public static final String MIGRATE_BOOKMARK_FILTERS = "BOOKMARKS_FILTERS_MIGRATE";
    public static final String MIGRATE_PROBLEM_FILTERS = "PROBLEMS_FILTERS_MIGRATE";
    public static final String MIGRATE_TASK_FILTERS = "TASKS_FILTERS_MIGRATE";
    public static final Object VALUE_FALSE = "false";

    static final Image createImage(String completeImagePath, ResourceManager manager) {
        URL url = BundleUtility.find((String)IDEWorkbenchPlugin.getDefault().getBundle().getSymbolicName(), (String)completeImagePath);
        if (url == null) {
            return null;
        }
        return manager.createImageWithDefault(ImageDescriptor.createFromURL((URL)url));
    }

    static final StatusAdapter errorFor(Throwable exception) {
        Status status = new Status(4, "org.eclipse.ui.ide", 4, exception.getLocalizedMessage(), exception);
        return new StatusAdapter((IStatus)status);
    }

    static final MarkerFieldFilter generateFilter(MarkerField field) {
        Object filter;
        block5: {
            IConfigurationElement configurationElement;
            block4: {
                configurationElement = field.getConfigurationElement();
                try {
                    if (configurationElement.getAttribute(ATTRIBUTE_FILTER_CLASS) != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    Policy.handle(e);
                    return null;
                }
            }
            filter = IDEWorkbenchPlugin.createExtension(configurationElement, ATTRIBUTE_FILTER_CLASS);
            if (filter != null) break block5;
            return null;
        }
        MarkerFieldFilter fieldFilter = (MarkerFieldFilter)filter;
        fieldFilter.setField(field);
        return fieldFilter;
    }

    static final FilterConfigurationArea generateFilterArea(MarkerField field) {
        IConfigurationElement configurationElement;
        block4: {
            configurationElement = field.getConfigurationElement();
            try {
                if (configurationElement.getAttribute(ATTRIBUTE_FILTER_CONFIGURATION_CLASS) != null) break block4;
                return null;
            }
            catch (CoreException e) {
                Policy.handle(e);
                return null;
            }
        }
        FilterConfigurationArea area = (FilterConfigurationArea)IDEWorkbenchPlugin.createExtension(configurationElement, ATTRIBUTE_FILTER_CONFIGURATION_CLASS);
        if (area != null) {
            area.setField(field);
        }
        return area;
    }

    public static final MarkerItem[] getChildren(MarkerItem markerItem) {
        if (markerItem instanceof MarkerCategory) {
            return ((MarkerCategory)markerItem).getChildren();
        }
        return EMPTY_MARKER_ITEM_ARRAY;
    }

    public static final int getFontWidth(Control control) {
        GC gc = new GC((Drawable)control.getDisplay());
        int width = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        return width;
    }

    public static final String getGroupValue(MarkerGroup group, MarkerItem item) {
        if (item.getMarker() == null) {
            return ((MarkerSupportItem)item).getDescription();
        }
        try {
            MarkerGroupingEntry groupingEntry = group.findGroupValue(item.getMarker().getType(), item.getMarker());
            return groupingEntry.getLabel();
        }
        catch (CoreException exception) {
            Policy.handle(exception);
            return EMPTY_STRING;
        }
    }

    public static final int getHighestSeverity(MarkerItem markerItem) {
        if (markerItem instanceof MarkerCategory) {
            MarkerCategory category = (MarkerCategory)markerItem;
            return category.getHighestSeverity();
        }
        IMarker marker = markerItem.getMarker();
        Assert.isNotNull((Object)marker);
        return marker.getAttribute("severity", 0);
    }

    public static final String getId(MarkerField field) {
        return field.getConfigurationElement().getAttribute(ATTRIBUTE_ID);
    }

    private static Image getIDEImage(String constantName) {
        return JFaceResources.getResources().createImageWithDefault(IDEInternalWorkbenchImages.getImageDescriptor(constantName));
    }

    static int getSeverity(MarkerItem item) {
        return item.getAttributeValue("severity", -1);
    }

    public static Image getSeverityImage(int severity) {
        if (severity == 2) {
            return MarkerSupportInternalUtilities.getIDEImage("IMG_OBJS_ERROR_PATH");
        }
        if (severity == 1) {
            return MarkerSupportInternalUtilities.getIDEImage("IMG_OBJS_WARNING_PATH");
        }
        if (severity == 0) {
            return MarkerSupportInternalUtilities.getIDEImage("IMG_OBJS_INFO_PATH");
        }
        return null;
    }

    static MarkerItem newMarkerItem(IMarker marker) {
        return new MarkerEntry(marker);
    }

    public static boolean showMarker(IViewPart view, IMarker marker) {
        if (view instanceof ExtendedMarkersView) {
            StructuredSelection selection = new StructuredSelection((Object)marker);
            ExtendedMarkersView markerView = (ExtendedMarkersView)view;
            markerView.setSelection(selection, true);
            return true;
        }
        return false;
    }

    public static void logViewError(Exception exception) {
        MarkerSupportInternalUtilities.handleViewError(exception, 1);
    }

    public static void showViewError(Exception exception) {
        MarkerSupportInternalUtilities.handleViewError(exception, 3);
    }

    public static void handleViewError(Exception exception, int handlingMethod) {
        if (exception instanceof CoreException) {
            IStatus status = ((CoreException)exception).getStatus();
            if (status != null && status.getException() instanceof CoreException) {
                exception = (CoreException)status.getException();
                status = ((CoreException)exception).getStatus();
            }
            if (status == null) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, exception.getLocalizedMessage(), exception), handlingMethod);
            } else {
                StatusManager.getManager().handle(status, handlingMethod);
            }
            return;
        }
        StatusManager.getManager().handle(StatusUtil.newStatus(4, exception.getLocalizedMessage(), exception), handlingMethod);
    }
}

