/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.l18n;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.wrap.WrappedReportExecutor;
import org.eclipse.birt.report.engine.presentation.LocalizedContentVisitor;
import org.eclipse.birt.report.engine.util.FastPool;

public class LocalizedReportExecutor
extends WrappedReportExecutor {
    IReportExecutor executor;
    LocalizedContentVisitor l18nVisitor;
    FastPool freeExecutors;

    public LocalizedReportExecutor(ExecutionContext context, IReportExecutor executor) {
        super(executor);
        this.l18nVisitor = new LocalizedContentVisitor(context);
        this.freeExecutors = new FastPool();
        this.executor = executor;
    }

    protected IReportItemExecutor createWrappedExecutor(IReportItemExecutor executor) {
        LocalizedReportItemExecutor l18nExecutor = null;
        if (!this.freeExecutors.isEmpty()) {
            l18nExecutor = (LocalizedReportItemExecutor)this.freeExecutors.remove();
            l18nExecutor.setExecutor(executor);
        } else {
            l18nExecutor = new LocalizedReportItemExecutor(this, executor);
        }
        return l18nExecutor;
    }

    protected void closeWrappedExecutor(IReportItemExecutor executor) {
        this.freeExecutors.add(executor);
    }

    public IReportContent execute() throws BirtException {
        IReportContent report = super.execute();
        if (report != null) {
            report = this.l18nVisitor.localizeReport(report);
        }
        return report;
    }
}

