/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.LinkedList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportletQuery {
    LinkedList<Query> queries = new LinkedList();
    ExecutionContext context;
    InstanceID iid;

    public ReportletQuery(ExecutionContext context, InstanceID iid) {
        this.context = context;
        this.iid = iid;
    }

    public IBaseResultSet[] getQueryResults() {
        if (!this.queries.isEmpty()) {
            Query query = this.queries.getLast();
            return query.rsets;
        }
        return null;
    }

    public void openReportletQueries() throws BirtException {
        LinkedList<InstanceID> parents = new LinkedList<InstanceID>();
        InstanceID parentId = this.iid.getParentID();
        while (parentId != null) {
            parents.addFirst(parentId);
            parentId = parentId.getParentID();
        }
        Report report = this.context.getReport();
        for (InstanceID pid : parents) {
            IDataQueryDefinition[] qs;
            ReportElementDesign design;
            DataID dataId = pid.getDataID();
            if (dataId != null && !this.queries.isEmpty()) {
                Query lastQuery = this.queries.getLast();
                lastQuery.rowId = dataId.getRowID();
                lastQuery.cellId = dataId.getCellID();
            }
            if (!((design = report.getReportItemByID(pid.getComponentID())) instanceof ReportItemDesign) || (qs = ((ReportItemDesign)design).getQueries()) == null) continue;
            this.queries.add(new Query(qs));
        }
        DataID dataId = this.iid.getDataID();
        if (!this.queries.isEmpty() && dataId != null) {
            Query lastQuery = this.queries.getLast();
            lastQuery.rowId = dataId.getRowID();
            lastQuery.cellId = dataId.getCellID();
        }
        this.executeQueries(this.queries);
    }

    void executeQueries(LinkedList<Query> queries) throws BirtException {
        IBaseResultSet rset = null;
        for (Query query : queries) {
            query.rsets = new IBaseResultSet[query.queries.length];
            int i = 0;
            while (i < query.queries.length) {
                query.rsets[i] = this.context.executeQuery(rset, query.queries[i], null, false);
                ++i;
            }
            rset = query.rsets[0];
            if (query.cellId != null) {
                ((ICubeResultSet)rset).skipTo(query.cellId);
            }
            if (query.rowId == -1L || rset.getType() != 0) continue;
            ((IQueryResultSet)rset).skipTo(query.rowId);
        }
    }

    public void closeReportletQueries() throws EngineException {
        for (Query query : this.queries) {
            if (query.rsets == null) continue;
            IBaseResultSet[] iBaseResultSetArray = query.rsets;
            int n = query.rsets.length;
            int n2 = 0;
            while (n2 < n) {
                IBaseResultSet rset = iBaseResultSetArray[n2];
                if (rset != null) {
                    rset.close();
                }
                ++n2;
            }
        }
        this.queries.clear();
    }

    private static class Query {
        IDataQueryDefinition[] queries;
        IBaseResultSet[] rsets;
        long rowId;
        String cellId;

        Query(IDataQueryDefinition[] qs) {
            this.queries = qs;
        }
    }
}

