/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Snippet050DelegatingStyledCellLabelProvider {
    private static final int SHELL_WIDTH = 640;
    private static final Display DISPLAY = Display.getDefault();

    public static void main(String[] args) {
        JFaceResources.getColorRegistry().put("COUNTER_COLOR", new RGB(0, 127, 174));
        Shell shell = new Shell(DISPLAY, 80);
        shell.setSize(640, 300);
        shell.setLayout((Layout)new GridLayout(1, false));
        Snippet050DelegatingStyledCellLabelProvider example = new Snippet050DelegatingStyledCellLabelProvider();
        example.createPartControl((Composite)shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (DISPLAY.readAndDispatch()) continue;
            DISPLAY.sleep();
        }
        DISPLAY.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, true));
        DelegatingStyledCellLabelProvider styledCellLP1 = new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new NameAndSizeLabelProvider());
        DelegatingStyledCellLabelProvider styledCellLP2 = new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ModifiedDateLabelProvider());
        ColumnViewer ownerDrawViewer = this.createViewer("Owner draw viewer:", composite, (CellLabelProvider)styledCellLP1, (CellLabelProvider)styledCellLP2);
        NameAndSizeLabelProvider normalLP1 = new NameAndSizeLabelProvider();
        ModifiedDateLabelProvider normalLP2 = new ModifiedDateLabelProvider();
        ColumnViewer normalViewer = this.createViewer("Normal viewer:", composite, (CellLabelProvider)normalLP1, (CellLabelProvider)normalLP2);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, true, true));
        buttons.setLayout((Layout)new GridLayout(3, false));
        Button button1 = new Button(buttons, 8);
        button1.setText("Refresh Viewers");
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ownerDrawViewer.refresh();
                normalViewer.refresh();
            }
        });
        Button button2 = new Button(buttons, 32);
        button2.setText("Owner draw on column 1");
        button2.setSelection(true);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newState = button2.getSelection();
                styledCellLP1.setOwnerDrawEnabled(newState);
                ownerDrawViewer.refresh();
            }
        });
        Button button3 = new Button(buttons, 32);
        button3.setText("Owner draw on column 2");
        button3.setSelection(true);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newState = button3.getSelection();
                styledCellLP2.setOwnerDrawEnabled(newState);
                ownerDrawViewer.refresh();
            }
        });
    }

    private ColumnViewer createViewer(String description, Composite parent, CellLabelProvider labelProvider1, CellLabelProvider labelProvider2) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(description);
        TreeViewer treeViewer = new TreeViewer(composite, 770);
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.setContentProvider((IContentProvider)new FileSystemContentProvider());
        TreeViewerColumn tvc1 = new TreeViewerColumn(treeViewer, 0);
        tvc1.getColumn().setText("Name");
        tvc1.getColumn().setWidth(200);
        tvc1.setLabelProvider(labelProvider1);
        TreeViewerColumn tvc2 = new TreeViewerColumn(treeViewer, 0);
        tvc2.getColumn().setText("Date Modified");
        tvc2.getColumn().setWidth(200);
        tvc2.setLabelProvider(labelProvider2);
        GridData data = new GridData(4, 4, true, true);
        treeViewer.getControl().setLayoutData((Object)data);
        treeViewer.setInput((Object)new FileSystemRoot());
        return treeViewer;
    }

    static /* synthetic */ Display access$0() {
        return DISPLAY;
    }

    private static class FileSystemContentProvider
    implements ITreeContentProvider {
        private FileSystemContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof File) {
                Object[] listFiles;
                File file = (File)element;
                if (file.isDirectory() && (listFiles = file.listFiles()) != null) {
                    return listFiles;
                }
            } else if (element instanceof FileSystemRoot) {
                return ((FileSystemRoot)element).getRoots();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof File) {
                File file = (File)element;
                return file.getParentFile();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class FileSystemRoot {
        private FileSystemRoot() {
        }

        public File[] getRoots() {
            return File.listRoots();
        }
    }

    private static class ModifiedDateLabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private ModifiedDateLabelProvider() {
        }

        public String getText(Object element) {
            return this.getStyledText(element).toString();
        }

        public StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            if (element instanceof File) {
                File file = (File)element;
                String date = DateFormat.getDateInstance().format(new Date(file.lastModified()));
                styledString.append(date);
                styledString.append(' ');
                String time = DateFormat.getTimeInstance(3).format(new Date(file.lastModified()));
                styledString.append(time, StyledString.COUNTER_STYLER);
            }
            return styledString;
        }
    }

    private static class NameAndSizeLabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static int IMAGE_SIZE = 16;
        private static final Image IMAGE1 = new Image((Device)Snippet050DelegatingStyledCellLabelProvider.access$0(), Snippet050DelegatingStyledCellLabelProvider.access$0().getSystemImage(8).getImageData().scaledTo(IMAGE_SIZE, IMAGE_SIZE));
        private static final Image IMAGE2 = new Image((Device)Snippet050DelegatingStyledCellLabelProvider.access$0(), Snippet050DelegatingStyledCellLabelProvider.access$0().getSystemImage(1).getImageData().scaledTo(IMAGE_SIZE, IMAGE_SIZE));

        private NameAndSizeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof File) {
                File file = (File)element;
                if (file.isDirectory()) {
                    return IMAGE1;
                }
                return IMAGE2;
            }
            return null;
        }

        public String getText(Object element) {
            return this.getStyledText(element).toString();
        }

        public StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            if (element instanceof File) {
                File file = (File)element;
                if (file.getName().length() == 0) {
                    styledString.append(file.getAbsolutePath());
                } else {
                    styledString.append(file.getName());
                }
                if (file.isFile()) {
                    String decoration = MessageFormat.format(" ({0} bytes)", new Long(file.length()));
                    styledString.append(decoration, StyledString.COUNTER_STYLER);
                }
            }
            return styledString;
        }
    }
}

