/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.wolfdbmanager;

import hiro.yoshioka.job.DBRefreshJob;
import hiro.yoshioka.preferences.SQTExecutionDialog;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.yaml.YamlTestWizard;
import hiro.yoshioka.sql.yaml.bean.Entry;
import hiro.yoshioka.ui.action.ConnectAction;
import hiro.yoshioka.ui.action.PreferenceModeDisplayAction;
import hiro.yoshioka.ui.action.SaveAction;
import hiro.yoshioka.ui.action.TransactionAction;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.vaction.NewEditorDropDownAction;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.Messages;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import hiro.yoshioka.yaml.editors.YamlEditor;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction openNewWindowAction;
    private ActionFactory.IWorkbenchAction preferenceAction;
    private ActionFactory.IWorkbenchAction customizePerspectiveAction;
    private ActionFactory.IWorkbenchAction savePerspectiveAction;
    private IContributionItem showViewListAction;
    private ConnectAction fConnectAction;
    private TransactionAction fCommitAction;
    private IContributionItem recentlyOpenEditors;
    private PreferenceModeDisplayAction fSwitchBlobModeAction;
    private SaveAction fSaveAction;
    private NewEditorDropDownAction fNewSQLEditorDropDownAction;
    private NewEditorDropDownAction fNewLSTEditorDropDownAction;
    private IContributionItem perspectivesMenu;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        try {
            this.preferenceAction = ActionFactory.PREFERENCES.create(window);
            this.customizePerspectiveAction = ActionFactory.EDIT_ACTION_SETS.create(window);
            this.savePerspectiveAction = ActionFactory.SAVE_PERSPECTIVE.create(window);
            this.openNewWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
            this.showViewListAction = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
            this.recentlyOpenEditors = ContributionItemFactory.REOPEN_EDITORS.create(window);
            this.fConnectAction = new ConnectAction();
            this.fCommitAction = new TransactionAction();
            this.perspectivesMenu = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
            this.registerAsGlobal((IAction)ActionFactory.SAVE.create(window));
            this.registerAsGlobal((IAction)ActionFactory.SAVE_AS.create(window));
            this.registerAsGlobal((IAction)ActionFactory.ABOUT.create(window));
            this.registerAsGlobal((IAction)ActionFactory.SAVE_ALL.create(window));
            this.registerAsGlobal((IAction)ActionFactory.UNDO.create(window));
            this.registerAsGlobal((IAction)ActionFactory.REDO.create(window));
            this.registerAsGlobal((IAction)ActionFactory.CUT.create(window));
            this.registerAsGlobal((IAction)ActionFactory.COPY.create(window));
            this.registerAsGlobal((IAction)ActionFactory.PASTE.create(window));
            this.registerAsGlobal((IAction)ActionFactory.SELECT_ALL.create(window));
            this.registerAsGlobal((IAction)ActionFactory.FIND.create(window));
            this.registerAsGlobal((IAction)ActionFactory.CLOSE.create(window));
            this.registerAsGlobal((IAction)ActionFactory.CLOSE_ALL.create(window));
            this.registerAsGlobal((IAction)ActionFactory.CLOSE_ALL_SAVED.create(window));
            this.registerAsGlobal((IAction)ActionFactory.REVERT.create(window));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void registerAsGlobal(IAction action) {
        this.getActionBarConfigurer().registerGlobalAction(action);
        this.register(action);
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(Messages.ApplicationActionBarAdvisor_33, "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add(this.getAction(ActionFactory.UNDO.getId()));
        menu.add(this.getAction(ActionFactory.REDO.getId()));
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add(this.getAction(ActionFactory.CUT.getId()));
        menu.add(this.getAction(ActionFactory.COPY.getId()));
        menu.add(this.getAction(ActionFactory.PASTE.getId()));
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add(this.getAction(ActionFactory.SELECT_ALL.getId()));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(ActionFactory.FIND.getId()));
        menu.add((IContributionItem)new GroupMarker("find.ext"));
        menu.add((IContributionItem)new GroupMarker("add.ext"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        return menu;
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(Messages.ApplicationActionBarAdvisor_34, "help");
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        menu.add((IContributionItem)new Separator(Messages.ApplicationActionBarAdvisor_39));
        menu.add(this.getAction(ActionFactory.ABOUT.getId()));
        menu.add((IAction)new Action("Online Help", ImageUtil.getImageDescriptor((String)"action/help.gif")){

            public void run() {
                Program.launch((String)"http://yonsama--blog.blogspot.com/2011/08/wolfdbmanager2-rcp-how-to-use.html");
            }
        });
        return menu;
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_36, "file");
        fileMenu.add(this.recentlyOpenEditors);
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)this.createEditMenu());
        MenuManager windowMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_37, "window");
        menuBar.add((IContributionItem)windowMenu);
        windowMenu.add((IAction)this.preferenceAction);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.customizePerspectiveAction);
        windowMenu.add((IAction)this.savePerspectiveAction);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.openNewWindowAction);
        MenuManager showViewMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_38);
        showViewMenu.add(this.showViewListAction);
        windowMenu.add((IContributionItem)showViewMenu);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.createHelpMenu());
        MenuManager layoutMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_SwitchLayout, Messages.ApplicationActionBarAdvisor_layout);
        layoutMenu.add(this.perspectivesMenu);
        menuBar.add((IContributionItem)layoutMenu);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        try {
            ToolBarManager toolbar = new ToolBarManager(0x820000);
            coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "main"));
            ActionContributionItem startItem = new ActionContributionItem((IAction)new StartAction());
            startItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            toolbar.add((IContributionItem)startItem);
            toolbar.add((IContributionItem)new Separator());
            this.fNewSQLEditorDropDownAction = new NewEditorDropDownAction("sql", "SQL", ImageManager.getImageDescriptor("action/edit_sql.png"), true);
            toolbar.add((IAction)this.fNewSQLEditorDropDownAction);
            toolbar.add((IContributionItem)new Separator());
            this.fNewLSTEditorDropDownAction = new NewEditorDropDownAction("lst", "LST", ImageManager.getImageDescriptor("action/table_analysis.png"), true);
            toolbar.add((IAction)this.fNewLSTEditorDropDownAction);
            toolbar.add((IContributionItem)new Separator());
            toolbar.add((IAction)new Action("Scenario Runner", ImageManager.getImageDescriptor("action/42open_sqt_editor.gif")){

                public void run() {
                    SQTExecutionDialog dialog = new SQTExecutionDialog(Display.getCurrent().getActiveShell());
                    dialog.open();
                }
            });
            toolbar.add((IContributionItem)new Separator());
            this.fSaveAction = new SaveAction();
            toolbar.add((IAction)this.fSaveAction);
            toolbar.add((IContributionItem)new Separator());
            ToolBarManager toolbar2 = new ToolBarManager(0x820000);
            coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar2, Messages.ApplicationActionBarAdvisor_24));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    class ConnectionsAdaptor
    extends RequestAdaptor
    implements SelectionListener {
        SQLOperationType myOperation;

        public ConnectionsAdaptor(SQLOperationType operation) {
            this.myOperation = operation;
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem mi = (MenuItem)e.getSource();
            ConnectionProperties p = (ConnectionProperties)mi.getData();
            Request request = new Request(this.myOperation, p);
            request.addListener((IRequestListener)this);
            SQLServerThread.putRequest((Request)request);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void called_done(Request request, SQLOperationType operation, ConnectionProperties properteis, Object o) {
            Application.setStatus(new Date() + "[" + properteis.getDisplayString() + "] " + request.result);
            Throwable ex = request.getException();
            if (ex != null) {
                Application.openErrorDialog(null, "error", ex);
            }
            if (this.myOperation == SQLOperationType.CONNECT && properteis.isConnected() && properteis.isCaptureResourceAfterTheConnectProcess()) {
                DBRefreshJob job = new DBRefreshJob(SQLOperationType.RESOURCE_CAPTION, properteis, properteis);
                job.setUser(true);
                job.schedule();
            }
        }
    }

    class StartAction
    extends Action {
        SQLServerThread server;

        public StartAction() {
            super(Messages.ApplicationActionBarAdvisor_Start, 4);
            this.server = SQLServerThread.getSQLServer();
            this.setImageDescriptor(ImageManager.getImageDescriptor("action/start.png"));
            this.setMenuCreator(new IMenuCreator(){

                public Menu getMenu(Control parent) {
                    Menu menu = new Menu(parent);
                    StartAction.this.createConfigMenu(menu);
                    new MenuItem(menu, 2);
                    StartAction.this.createConnectionMenu(menu);
                    new MenuItem(menu, 2);
                    StartAction.this.createNewEditorMenu(menu);
                    new MenuItem(menu, 2);
                    StartAction.this.createNewWizardMenu(menu);
                    return menu;
                }

                public Menu getMenu(Menu parent) {
                    return null;
                }

                public void dispose() {
                }
            });
        }

        void createMenusForConnections(Menu menu, String actionMenuName, Image menuImage, SQLOperationType operationType, SelectionListener selectionListener) {
            MenuItem mi_lst = new MenuItem(menu, 64);
            mi_lst.setText(actionMenuName);
            if (menuImage != null) {
                mi_lst.setImage(menuImage);
            }
            Menu m_lst = new Menu(menu);
            mi_lst.setMenu(m_lst);
            for (ConnectionProperties p : this.server.getConnectionList()) {
                boolean isConnected = p.isConnected();
                if (!isConnected && operationType != SQLOperationType.CONNECT && operationType != SQLOperationType.CLOSE) continue;
                MenuItem openNewLstEditor = new MenuItem(m_lst, 0);
                openNewLstEditor.setData((Object)p);
                openNewLstEditor.setText(p.getDisplayString());
                if (p.isConnected()) {
                    openNewLstEditor.setImage(ImageUtil.getImage((String)"action/32connect.gif"));
                } else {
                    openNewLstEditor.setImage(ImageUtil.getImage((String)"action/33disconnect.gif"));
                }
                if (selectionListener == null) {
                    openNewLstEditor.addSelectionListener((SelectionListener)new ConnectionsAdaptor(operationType));
                    continue;
                }
                openNewLstEditor.addSelectionListener(selectionListener);
            }
        }

        void createConfigMenu(Menu topMenu) {
            MenuItem cascade = new MenuItem(topMenu, 64);
            cascade.setText(Messages.ApplicationActionBarAdvisor_Config);
            cascade.setImage(ImageUtil.getImage((String)"dbresource/asterisk.gif"));
            Menu menu = new Menu(cascade);
            cascade.setMenu(menu);
            MenuItem mi_config = new MenuItem(menu, 64);
            mi_config.setText(Messages.ApplicationActionBarAdvisor_Connection);
            mi_config.setImage(ImageUtil.getImage((String)"action/32connect.gif"));
            mi_config.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExplorerView view = (ExplorerView)Application.findActiveView("ExplorerID");
                    if (view != null) {
                        view.openConfigDialog();
                    }
                }
            });
            mi_config = new MenuItem(menu, 64);
            mi_config.setText(Messages.ApplicationActionBarAdvisor_SQLFormatter);
            mi_config.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Application.openPreferenceDialog("FormatPreferencePageID");
                }
            });
            mi_config = new MenuItem(menu, 64);
            mi_config.setText(Messages.ApplicationActionBarAdvisor_ExcelWriter);
            mi_config.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Application.openPreferenceDialog("EXCELPreferencePageID");
                }
            });
        }

        void createConnectionMenu(Menu topMenu) {
            MenuItem cascade = new MenuItem(topMenu, 64);
            cascade.setText(Messages.ApplicationActionBarAdvisor_Connections);
            cascade.setImage(ImageUtil.getImage((String)"action/32connect.gif"));
            Menu menu = new Menu(cascade);
            cascade.setMenu(menu);
            MenuItem mi_config = new MenuItem(menu, 64);
            mi_config.setText(Messages.ApplicationActionBarAdvisor_Config);
            mi_config.setImage(ImageUtil.getImage((String)"dbresource/asterisk.gif"));
            mi_config.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExplorerView view = (ExplorerView)Application.findActiveView("ExplorerID");
                    if (view != null) {
                        view.openConfigDialog();
                    }
                }
            });
            new MenuItem(menu, 2);
            this.createMenusForConnections(menu, Messages.ApplicationActionBarAdvisor_Connect, ImageUtil.getImage((String)"action/32connect.gif"), SQLOperationType.CONNECT, null);
            this.createMenusForConnections(menu, Messages.ApplicationActionBarAdvisor_DisConnect, ImageUtil.getImage((String)"action/33disconnect.gif"), SQLOperationType.CLOSE, null);
            new MenuItem(menu, 2);
            this.createMenusForConnections(menu, Messages.ApplicationActionBarAdvisor_Cansel, ImageUtil.getImage((String)"action/39cancel.gif"), SQLOperationType.CANSEL, null);
            this.createMenusForConnections(menu, Messages.ApplicationActionBarAdvisor_Commit, ImageUtil.getImage((String)"action/43go.gif"), SQLOperationType.COMMIT, null);
            this.createMenusForConnections(menu, Messages.ApplicationActionBarAdvisor_Rollback, ImageUtil.getImage((String)"action/42back.gif"), SQLOperationType.ROLLBACK, null);
        }

        void createNewEditorMenu(Menu topMenu) {
            MenuItem cascade = new MenuItem(topMenu, 64);
            cascade.setText(Messages.ApplicationActionBarAdvisor_OpenANewEditor);
            Menu menu = new Menu(cascade);
            cascade.setMenu(menu);
            this.createMenusForConnections(menu, Messages.ApplicationActionBarAdvisor_sqlStatementEditor, ImageManager.getImageDescriptor("action/edit_sql.png").createImage(), SQLOperationType.TEST, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem mi = (MenuItem)e.getSource();
                    ConnectionProperties cfr_ignored_0 = (ConnectionProperties)mi.getData();
                    IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.sqlFolder);
                    IFile file = ResourceMarker.createRandomFile(folder, ResourceMarker.sqlFolder);
                    Application.openNewSQLEditor(file, ((MenuItem)e.widget).getText());
                }
            });
            this.createMenusForConnections(menu, Messages.ApplicationActionBarAdvisor_tableDumpInformationEditor, ImageManager.getImageDescriptor("action/table_analysis.png").createImage(), SQLOperationType.TEST, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem mi = (MenuItem)e.getSource();
                    ConnectionProperties p = (ConnectionProperties)mi.getData();
                    IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.lstFolder);
                    IFile file = ResourceMarker.createRandomFile(folder, ResourceMarker.lstFolder);
                    Application.openNewSchemaDiagramEditor(file, p);
                }
            });
        }

        void createNewWizardMenu(Menu topMenu) {
            MenuItem cascade = new MenuItem(topMenu, 64);
            cascade.setText(Messages.ApplicationActionBarAdvisor_OpenANewWizard);
            Menu menu = new Menu(cascade);
            cascade.setMenu(menu);
            MenuItem mi_sql = new MenuItem(menu, 64);
            mi_sql.setText(Messages.ApplicationActionBarAdvisor_sqlPerformanceMeasurement);
            mi_sql.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    YamlTestWizard wizard = new YamlTestWizard(new Entry());
                    WizardDialog dialog = new WizardDialog(e.display.getActiveShell(), (IWizard)wizard);
                    if (1 != dialog.open()) {
                        Entry entry = wizard.getEntry();
                        System.out.println(entry);
                        IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.yamlFolder);
                        IFile file = ResourceMarker.createFile(folder, String.valueOf(entry.title) + ".yaml");
                        YamlEditor editor = Application.openNewYamlEditor(file);
                        editor.setYamlText(entry.dump());
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                }
            });
        }

        public void runWithEvent(Event e) {
            ToolItem ti = (ToolItem)e.widget;
            Menu m = this.getMenuCreator().getMenu((Control)ti.getParent());
            Point point = ti.getParent().toDisplay(new Point(e.x, e.y + 25));
            m.setLocation(point.x, point.y);
            m.setVisible(true);
        }
    }
}

