/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.vaction;

import hiro.yoshioka.sdh.pair.DifferenceStringData;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.ui.view.DiffResultSetView;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ResultSet2RestoreScrpitAction
implements IViewActionDelegate {
    public static final String ID = "ResultSet2RestoreScrpitActionID";
    protected transient Log fLogger = LogFactory.getLog(this.getClass());
    private DiffResultSetView fView;

    public void init(IViewPart view) {
        this.fView = (DiffResultSetView)view;
    }

    public void run(IAction action) {
        try {
            ResultSetDataHolder2[][] rdhs = this.fView.getInput();
            StringBuilder buf = new StringBuilder();
            int[][] pos = this.fView.getMatchingPos();
            int i = 0;
            while (i < pos.length) {
                int j = 0;
                while (j < pos[i].length) {
                    System.out.println("pos[" + i + "][" + j + "]=" + pos[i][j]);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < rdhs[0].length) {
                this.genScript(rdhs[0][i], rdhs[1][i], buf);
                ++i;
            }
            ConnectionProperties p = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionPropertiesByDisplay(this.fView.getConnectionPropertiesDisplay());
            if (p != null && p.getDatabaseType().isOracle()) {
                DBRoot root = p.getDBRootResource();
                if (buf.toString().trim().length() > 0 && root.getDatabaseVersion() > 9.0) {
                    buf.insert(0, "ALTER SESSION SET NLS_TIMESTAMP_FORMAT='yyyy-mm-dd hh24:mi:ss.ff';" + StringUtil.LINE_SEPARATOR);
                    buf.insert(0, "ALTER SESSION SET NLS_DATE_FORMAT='yyyy-mm-dd';" + StringUtil.LINE_SEPARATOR);
                }
            }
            SQLEditor editor = Application.openNewSQLEditor(null, this.fView.getConnectionPropertiesDisplay());
            editor.setText(buf.toString());
        }
        catch (Throwable e) {
            this.fLogger.error((Object)e);
        }
    }

    private void genScript(ResultSetDataHolder2 lrdh, ResultSetDataHolder2 rrdh, StringBuilder buf) {
        DifferenceStringData diff;
        int j;
        String[] keys;
        int i = 0;
        while (i < lrdh.getRowCount()) {
            keys = lrdh.getKey();
            j = 1;
            while (j < keys.length) {
                diff = (DifferenceStringData)lrdh.getPair(i, j);
                if (!diff.fDifferenceKind.isNoChange()) {
                    if (diff.fDifferenceKind.isAddition()) {
                        buf.append(lrdh.generateInsertScript(i));
                        buf.append(StringUtil.LINE_SEPARATOR);
                        break;
                    }
                    if (diff.fDifferenceKind.isChange()) {
                        buf.append(lrdh.generateUpdateScript(i));
                        buf.append(StringUtil.LINE_SEPARATOR);
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < rrdh.getRowCount()) {
            keys = rrdh.getKey();
            j = 1;
            while (j < keys.length) {
                diff = (DifferenceStringData)rrdh.getPair(i, j);
                if (!diff.fDifferenceKind.isNoChange() && diff.fDifferenceKind.isAddition()) {
                    buf.append(rrdh.generateDeleteScript(i));
                    buf.append(StringUtil.LINE_SEPARATOR);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

