/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.preferences.DDL;
import hiro.yoshioka.preferences.DDL2;
import hiro.yoshioka.preferences.ExcelDefData;
import hiro.yoshioka.preferences.ReadExcelDefinitionDialog;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.view.DBResourceTreeSelection;
import hiro.yoshioka.sql.ui.editor.SQLEditor;
import hiro.yoshioka.ui.action.AbsWorkbenchSQLEditorAction;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class ReadExcelDefinitionAction
extends AbsWorkbenchSQLEditorAction
implements ISelectionChangedListener {
    protected ExplorerView fView;
    Log fLogger = LogFactory.getLog(this.getClass());
    private DBResourceTreeSelection fDBResourceTreeSelection;

    public ReadExcelDefinitionAction(ExplorerView view) {
        super(1);
        this.setText("ReadExcel");
        this.fView = view;
        this.setEnabled(true);
        this.setImageDescriptor(ImageUtil.getImageDescriptor((String)"action/script_excel.png"));
    }

    @Override
    public void update() {
        Application.exec(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    @Override
    public void execute(SQLEditor editor0, ConnectionProperties p) throws Exception {
        try {
            ReadExcelDefinitionDialog dialog = new ReadExcelDefinitionDialog(this.fView.getTreeViewer().getTree().getShell());
            if (dialog.open() == 0) {
                ExcelDefData data = dialog.getExcelDefData();
                if (data.is_create_table_ddl) {
                    IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.sqlFolder);
                    IFile file = ResourceMarker.createRandomFile(folder, ResourceMarker.sqlFolder);
                    SQLEditor editor = Application.openNewSQLEditor(file, this.fView.getSelectedConnectionProperties().getDisplayString());
                    DDL ddl3 = new DDL(data);
                    String text = ddl3.doWork();
                    editor.setText(text);
                } else if (data.is_create_comment_ddl) {
                    IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.sqlFolder);
                    IFile file = ResourceMarker.createRandomFile(folder, ResourceMarker.sqlFolder);
                    SQLEditor editor = Application.openNewSQLEditor(file, this.fView.getSelectedConnectionProperties().getDisplayString());
                    DDL2 ddl2 = new DDL2(data);
                    String text = ddl2.doWork();
                    editor.setText(text);
                }
            }
        }
        catch (Throwable e) {
            Application.openErrorDialog(null, "[Migration 2 Action Error]", e);
        }
    }
}

