/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.ui.editor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SQLColorProvider {
    static SQLColorProvider single;
    public static final RGB DEFAULT;
    public static final RGB PUNCT;
    public static final RGB SQL_MULTILINE_COMMENT;
    public static final RGB SQL_SINGLELINE_COMMENT;
    public static final RGB SQL_KEYWORD;
    public static final RGB SQL_STRING;
    public static final RGB SQL_NUMBER_FUNCTION;
    public static final RGB SQL_STRING_FUNCTION;
    public static final RGB SQL_SYSTEM_FUNCTION;
    public static final RGB SQL_TIME_DATE_FUNCTION;
    public static final RGB SQL_NUMBER;
    protected static Map fColorTable;

    static {
        DEFAULT = new RGB(0, 0, 0);
        PUNCT = new RGB(157, 155, 200);
        SQL_MULTILINE_COMMENT = new RGB(0, 128, 64);
        SQL_SINGLELINE_COMMENT = new RGB(64, 128, 64);
        SQL_KEYWORD = new RGB(0, 0, 160);
        SQL_STRING = new RGB(128, 128, 255);
        SQL_NUMBER_FUNCTION = new RGB(0, 0, 198);
        SQL_STRING_FUNCTION = new RGB(0, 0, 128);
        SQL_SYSTEM_FUNCTION = new RGB(0, 128, 128);
        SQL_TIME_DATE_FUNCTION = new RGB(0, 250, 128);
        SQL_NUMBER = new RGB(255, 0, 0);
        fColorTable = new HashMap();
    }

    private SQLColorProvider() {
    }

    public static SQLColorProvider getInstance() {
        if (single == null) {
            single = new SQLColorProvider();
        }
        return single;
    }

    public Color getColor(RGB rgb) {
        Color color = (Color)fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            fColorTable.put(rgb, color);
        }
        return color;
    }

    public Color getBackground(RGB rgb) {
        return this.getColor(rgb);
    }

    public void dispose() {
        Iterator e = fColorTable.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
    }
}

