/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.selenium;

import hiro.yoshioka.selenium.inspect.ExpectionType;
import hiro.yoshioka.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IssueParamPaser {
    private static Pattern P_ISSUE_PARAM = Pattern.compile("(c|u|d)\\s*((>=|<=|>|<|=|\\!=)\\s*([0-9]+))?", 2);

    public static void main(String[] args) {
        Map<CUDType, IssueParam> map = IssueParamPaser.parse("c,u, d");
        System.out.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        System.out.println(map);
        map = IssueParamPaser.parse("u > 30");
        System.out.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        System.out.println(map);
        map = IssueParamPaser.parse("ud");
        System.out.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        System.out.println(map);
    }

    public static Map<CUDType, IssueParam> parse(String target_string) {
        if (StringUtil.isEmpty((Object)target_string)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<CUDType, IssueParam> map = new HashMap<CUDType, IssueParam>();
        Matcher m = P_ISSUE_PARAM.matcher(target_string);
        while (m.find()) {
            IssueParam param = new IssueParam(CUDType.parse(m.group(1)), ExpectionType.parse(m.group(3)), m.group(4));
            map.put(param.getCud_type(), param);
        }
        CUDType[] cUDTypeArray = CUDType.values();
        int n = cUDTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CUDType cud_type = cUDTypeArray[n2];
            if (!map.containsKey((Object)cud_type)) {
                map.put(cud_type, new IssueParam(cud_type, ExpectionType.equals, "0"));
            }
            ++n2;
        }
        return map;
    }

    public static enum CUDType {
        Create("c"),
        Update("u"),
        Delete("d");

        private final String prefix;

        private CUDType(String prefix) {
            this.prefix = prefix;
        }

        public static CUDType parse(String target) {
            CUDType[] cUDTypeArray = CUDType.values();
            int n = cUDTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CUDType type = cUDTypeArray[n2];
                if (type.name().equalsIgnoreCase(target) || type.getPrefix().equalsIgnoreCase(target)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static class IssueParam {
        private CUDType cud_type;
        private ExpectionType comparator;
        private Integer expected_value;

        public IssueParam() {
        }

        public IssueParam(CUDType cud_type, ExpectionType comparator, String expected_value_str) {
            this.cud_type = cud_type;
            if (comparator != null && !StringUtil.isEmpty((Object)expected_value_str)) {
                this.comparator = comparator;
                try {
                    this.expected_value = Integer.parseInt(expected_value_str, 10);
                }
                catch (Exception exception) {}
            }
            if (this.comparator == null || this.expected_value == null) {
                this.comparator = ExpectionType.greater_equal;
                this.expected_value = 1;
            }
        }

        public String toString() {
            if (this.comparator == null) {
                return this.cud_type.toString();
            }
            return String.format("%s [%s] [%d]", new Object[]{this.cud_type, this.comparator, this.expected_value});
        }

        public CUDType getCud_type() {
            return this.cud_type;
        }

        public void setCud_type(CUDType cud_type) {
            this.cud_type = cud_type;
        }

        public ExpectionType getComparator() {
            return this.comparator;
        }

        public void setComparator(ExpectionType comparator) {
            this.comparator = comparator;
        }

        public Integer getExpected_value() {
            return this.expected_value;
        }

        public void setExpected_value(Integer expected_value) {
            this.expected_value = expected_value;
        }
    }
}

