/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.gef.action.GEFFlashBackAction;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class RetentionDialog
extends Dialog {
    Spinner fSpinner;
    private int minute;
    private boolean okEnable;
    static final String TIME = "SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME) = 'undo_retention'";
    ConnectionProperties properties;

    public RetentionDialog(Shell shell, ConnectionProperties properties) {
        super(shell);
        this.properties = properties;
    }

    protected Control createDialogArea(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm root = toolkit.createScrolledForm(parent);
        root.setText("FlashBack Time");
        root.getBody().setLayout((Layout)new GridLayout(1, false));
        Section section = toolkit.createSection(root.getBody(), 448);
        section.setText("FlashBack Time (MINUTE)");
        section.setDescription("MAXIMUN TIME DEFINED AT SYSTEM PARAMETER, CHANGE BY ALTER STATEMENTE!");
        Composite inner = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        inner.setLayout((Layout)layout);
        layout.numColumns = 3;
        toolkit.createLabel(inner, "Time(minute)");
        toolkit.createLabel(inner, ":");
        this.fSpinner = new Spinner(inner, 2120);
        this.fSpinner.setLayoutData((Object)new GridData(768));
        this.fSpinner.setSelection(10);
        this.fSpinner.setMinimum(1);
        ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(this.properties);
        try {
            ResultSetDataHolder2 rdh = sql.executePrepareQuery(TIME, (Object[])GEFFlashBackAction.EMPTY);
            int max = rdh.getIntData(0, "VALUE") / 60;
            this.fSpinner.setMaximum(max);
            if (max - 5 > 0) {
                this.fSpinner.setSelection(max - 5);
            } else {
                this.fSpinner.setSelection(max);
            }
            toolkit.createLabel(inner, "Maxmum Time");
            toolkit.createLabel(inner, ":");
            String message = "%d  TRANSACTION CAN CANCEL FROM [%tT]";
            Calendar cal = GregorianCalendar.getInstance();
            int d = -max;
            cal.add(12, d);
            toolkit.createLabel(inner, String.format(message, max, cal.getTime()), 2048);
        }
        catch (SQLException e) {
            toolkit.createLabel(inner, "Exception");
            toolkit.createLabel(inner, ":");
            toolkit.createLabel(inner, "Cant Get Value Of [undo_retention] FROM V$PARAMETER, CHANGE USER SYSDBA", 2048);
            e.printStackTrace();
            this.okEnable = true;
        }
        section.setClient((Control)inner);
        section.setLayoutData((Object)new GridData(1808));
        return root;
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        if (this.okEnable) {
            this.getOKButton().setEnabled(false);
        }
        return c;
    }

    public int getMinuite() {
        return this.minute;
    }

    protected void okPressed() {
        try {
            this.minute = this.fSpinner.getSelection();
            super.okPressed();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

