/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.generator.usingrdh;

import hiro.yoshioka.generator.TextFormatter;
import hiro.yoshioka.generator.usingrdh.Messages;
import hiro.yoshioka.util.StringUtil;
import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextFileGeneratorDialog
extends Dialog {
    static final String[] EXTENSIONS = new String[]{"*.csv;*.txt", "*.*"};
    public boolean sequencial;
    public boolean splitted = true;
    public String filePath;
    private Text textArea;

    public TextFileGeneratorDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.getString("TextFileGeneratorDialog.TITLE"));
        try {
            Composite c = new Composite(parent, 0);
            GridData data = new GridData(1808);
            c.setLayoutData((Object)data);
            c.setLayout((Layout)new GridLayout(2, false));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.makeColumnsEqualWidth = false;
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            c.setLayout((Layout)layout);
            new Label(c, 0).setText(Messages.getString("TextFileGeneratorDialog.SequencialRead"));
            Button btSequencail = new Button(c, 32);
            btSequencail.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextFileGeneratorDialog.this.sequencial = btSequencail.getSelection();
                    TextFileGeneratorDialog.this.refresh();
                }
            });
            new Label(c, 0).setText(Messages.getString("TextFileGeneratorDialog.SpaceSeparateName"));
            Button btnSeparated = new Button(c, 32);
            btnSeparated.setSelection(this.splitted);
            btnSeparated.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextFileGeneratorDialog.this.splitted = btnSeparated.getSelection();
                    TextFileGeneratorDialog.this.refresh();
                }
            });
            new Label(c, 0).setText(Messages.getString("TextFileGeneratorDialog.TextFile"));
            Button btnOpen = new Button(c, 8);
            btnOpen.setText(Messages.getString("TextFileGeneratorDialog.Open"));
            btnOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(TextFileGeneratorDialog.this.getShell());
                    dialog.setFilterExtensions(EXTENSIONS);
                    TextFileGeneratorDialog.this.filePath = dialog.open();
                    TextFileGeneratorDialog.this.refresh();
                }
            });
            Label lbPrev = new Label(c, 0);
            lbPrev.setText(Messages.getString("TextFileGeneratorDialog.Preview"));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            lbPrev.setLayoutData((Object)gd);
            this.textArea = new Text(c, 522);
            GridData gd2 = new GridData(1808);
            gd2.horizontalSpan = 2;
            gd2.minimumHeight = 240;
            this.textArea.setLayoutData((Object)gd2);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return parent;
    }

    private void refresh() {
        try {
            if (StringUtil.isEmpty((Object)this.filePath)) {
                this.textArea.setText("");
                this.getButton(0).setEnabled(false);
                return;
            }
            File f = new File(this.filePath);
            if (f.isFile() && f.length() > 0L) {
                TextFormatter fmt = new TextFormatter();
                fmt.setFilePath(this.filePath);
                fmt.setSequencial(this.sequencial);
                fmt.setSplitted(this.splitted);
                String str = fmt.getPreviewText();
                this.textArea.setText(str);
                if (StringUtil.isEmpty((Object)str)) {
                    this.getButton(0).setEnabled(false);
                } else {
                    this.getButton(0).setEnabled(true);
                }
            } else {
                this.textArea.setText("");
                this.getButton(0).setEnabled(false);
                return;
            }
            this.textArea.redraw();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

