/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.IGroupedDataRowExpressionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.Serializer;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.reportitem.ChartCubeQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemFactoryBase;
import org.eclipse.birt.chart.reportitem.IChartReportItemFactory;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.api.IChartReportItem;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.IReportItemPresentationInfo;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ExpressionListHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartReportItemUtil
extends ChartItemUtil {
    public static final int REVISE_REFERENCE_REPORT_ITEM = 1;
    private static final IChartReportItemFactory baseFactory = new ChartReportItemFactoryBase();

    public static void reviseChartModel(int reviseType, Chart cm, ReportItemHandle itemHandle) {
        switch (reviseType) {
            case 1: {
                String[] categoryExprs = ChartUtil.getCategoryExpressions((Chart)cm);
                if (itemHandle.getDataBindingReference() == null || !ChartReportItemUtil.isBaseGroupingDefined(cm) || categoryExprs.length > 0 && ChartReportItemUtil.isSharedGroupExpression(categoryExprs[0], itemHandle)) break;
                SeriesDefinition baseSD = null;
                if (cm instanceof ChartWithAxes) {
                    ChartWithAxes cwa = (ChartWithAxes)cm;
                    baseSD = (SeriesDefinition)cwa.getBaseAxes()[0].getSeriesDefinitions().get(0);
                } else if (cm instanceof ChartWithoutAxes) {
                    ChartWithoutAxes cwoa = (ChartWithoutAxes)cm;
                    baseSD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
                }
                if (baseSD == null || baseSD.getGrouping() == null) break;
                baseSD.getGrouping().unsetEnabled();
            }
        }
    }

    public static boolean isOldChartUsingInternalGroup(ReportItemHandle chartHandle, Chart cm) {
        String reportVer = chartHandle.getModuleHandle().getVersion();
        if (reportVer == null || ChartUtil.compareVersion((String)reportVer, (String)"3.2.16") < 0) {
            return true;
        }
        return chartHandle.getDataBindingReference() != null && ChartReportItemUtil.isBaseGroupingDefined(cm) && ChartReportItemUtil.isSharingTableData(chartHandle) && !ChartReportItemUtil.isSharedGroupExpression(ChartUtil.getCategoryExpressions((Chart)cm)[0], chartHandle);
    }

    private static boolean isSharingTableData(ReportItemHandle handle) {
        return ChartReportItemUtil.getReportItemReference(handle) instanceof ListingHandle;
    }

    private static boolean isSharedGroupExpression(String expression, ReportItemHandle handle) {
        ReportItemHandle itemHandle = ChartReportItemUtil.getReportItemReference(handle);
        if (itemHandle instanceof ListingHandle) {
            ArrayList<GroupHandle> groupList = new ArrayList<GroupHandle>();
            SlotHandle groups = ((ListingHandle)itemHandle).getGroups();
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                groupList.add((GroupHandle)iter.next());
            }
            if (groupList.size() == 0) {
                return false;
            }
            ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
            for (GroupHandle gh : groupList) {
                ChartReportItemUtil.loadExpression(exprCodec, gh);
                if (!expression.contains(exprCodec.getBindingName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(IBaseResultSet set) throws BirtException {
        if (set instanceof IQueryResultSet) {
            return ((IQueryResultSet)set).isEmpty();
        }
        return false;
    }

    public static <T> T getAdapter(Object adaptable, Class<T> adapterClass) {
        IAdapterManager adapterManager = Platform.getAdapterManager();
        return adapterClass.cast(adapterManager.loadAdapter(adaptable, adapterClass.getName()));
    }

    public static IReportItemPresentation instanceReportItemPresentation(ExtendedItemHandle handle, IReportItemPresentationInfo info) {
        IChartReportItemFactory factory = ChartReportItemUtil.getAdapter(handle, IChartReportItemFactory.class);
        if (factory == null) {
            factory = baseFactory;
        }
        return factory.createReportItemPresentation(info);
    }

    public static IActionRenderer instanceActionRenderer(ExtendedItemHandle handle, IHTMLActionHandler handler, IDataRowExpressionEvaluator evaluator, IReportContext context) {
        IChartReportItemFactory factory = ChartReportItemUtil.getAdapter(handle, IChartReportItemFactory.class);
        if (factory == null) {
            factory = baseFactory;
        }
        return factory.createActionRenderer((DesignElementHandle)handle, handler, evaluator, context);
    }

    public static Serializer instanceSerializer(ExtendedItemHandle handle) {
        IChartReportItemFactory factory = ChartReportItemUtil.getAdapter(handle, IChartReportItemFactory.class);
        if (factory == null) {
            factory = baseFactory;
        }
        return factory.createSerializer(handle);
    }

    public static ChartCubeQueryHelper instanceCubeQueryHelper(ExtendedItemHandle handle, Chart cm, IModelAdapter modelAdapter) {
        IChartReportItemFactory factory = ChartReportItemUtil.getAdapter(handle, IChartReportItemFactory.class);
        if (factory == null) {
            factory = baseFactory;
        }
        return factory.createCubeQueryHelper(handle, cm, modelAdapter);
    }

    public static IGroupedDataRowExpressionEvaluator instanceCubeEvaluator(ExtendedItemHandle handle, Chart cm, ICubeResultSet set) {
        IChartReportItemFactory factory = ChartReportItemUtil.getAdapter(handle, IChartReportItemFactory.class);
        if (factory == null) {
            factory = baseFactory;
        }
        return factory.createCubeEvaluator(cm, set);
    }

    public static IChartReportItem instanceChartReportItem(ExtendedItemHandle handle) {
        IChartReportItemFactory factory = ChartReportItemUtil.getAdapter(handle, IChartReportItemFactory.class);
        if (factory == null) {
            factory = baseFactory;
        }
        return factory.createChartReportItem(handle);
    }

    public static boolean canScaleShared(ReportItemHandle eih, Chart cm) {
        return cm instanceof ChartWithAxes && eih.getDataSet() == null && ChartReportItemUtil.getBindingHolder((DesignElementHandle)eih) != null && ChartCubeUtil.isInXTabMeasureCell((DesignElementHandle)eih);
    }

    public static void copyAndInsertBindingFromContainer(ISubqueryDefinition query, String expr) throws DataException {
        ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        String bindingName = exprCodec.getRowBindingName(expr, false);
        if (bindingName != null && !query.getBindings().containsKey(bindingName) && query.getParentQuery().getBindings().containsKey(bindingName)) {
            List argumentsList;
            IBinding parentBinding = (IBinding)query.getParentQuery().getBindings().get(bindingName);
            Binding binding = new Binding(bindingName, parentBinding.getExpression());
            binding.setAggrFunction(parentBinding.getAggrFunction());
            binding.setDataType(parentBinding.getDataType());
            binding.setDisplayName(parentBinding.getDisplayName());
            binding.setFilter(parentBinding.getFilter());
            List aggregationOnList = parentBinding.getAggregatOns();
            if (aggregationOnList != null) {
                for (String aggregateOn : aggregationOnList) {
                    GroupDefinition group;
                    binding.addAggregateOn(aggregateOn);
                    if (ChartReportItemUtil.findGroupInQuery((IBaseQueryDefinition)query, aggregateOn) != null || (group = ChartReportItemUtil.findGroupInQuery(query.getParentQuery(), aggregateOn)) == null) continue;
                    ((SubqueryDefinition)query).addGroup(group);
                }
            }
            if ((argumentsList = parentBinding.getArguments()) != null) {
                for (Object argument : argumentsList) {
                    binding.addArgument((IBaseExpression)argument);
                }
            }
            query.addBinding((IBinding)binding);
        }
    }

    private static GroupDefinition findGroupInQuery(IBaseQueryDefinition query, String groupName) {
        List groups = query.getGroups();
        if (groups != null) {
            for (GroupDefinition group : groups) {
                if (!group.getName().equals(groupName)) continue;
                return group;
            }
        }
        return null;
    }

    public static void copyChartSampleData(Chart srcCM, Chart targetCM) {
        if (srcCM.getSampleData() != null) {
            targetCM.setSampleData(srcCM.getSampleData().copyInstance());
        } else {
            targetCM.setSampleData(null);
        }
    }

    public static void copyChartSeriesDefinition(Chart srcCM, Chart targetCM) {
        boolean isSameType = srcCM.getType().equals(targetCM.getType());
        EList srcRsds = ChartUtil.getBaseSeriesDefinitions((Chart)srcCM);
        EList tagRsds = ChartUtil.getBaseSeriesDefinitions((Chart)targetCM);
        int i = 0;
        while (i < srcRsds.size()) {
            SeriesDefinition sd = (SeriesDefinition)srcRsds.get(i);
            SeriesDefinition tagSD = null;
            if (i >= tagRsds.size()) {
                tagSD = SeriesDefinitionImpl.create();
                if (targetCM instanceof ChartWithAxes) {
                    ((Axis)((ChartWithAxes)targetCM).getAxes().get(0)).getSeriesDefinitions().add((Object)tagSD);
                } else if (targetCM instanceof ChartWithoutAxes) {
                    ((ChartWithoutAxes)targetCM).getSeriesDefinitions().add((Object)tagSD);
                }
            } else {
                tagSD = (SeriesDefinition)tagRsds.get(i);
            }
            ChartReportItemUtil.copySDQueryAttributes(sd, tagSD);
            ++i;
        }
        if (targetCM instanceof ChartWithAxes) {
            EList tagAxisList = ((Axis)((ChartWithAxes)targetCM).getAxes().get(0)).getAssociatedAxes();
            if (srcCM instanceof ChartWithAxes) {
                EList srcAxisList = ((Axis)((ChartWithAxes)srcCM).getAxes().get(0)).getAssociatedAxes();
                if (tagAxisList.size() > srcAxisList.size()) {
                    int i2 = tagAxisList.size() - 1;
                    while (i2 >= srcAxisList.size()) {
                        tagAxisList.remove(i2);
                        --i2;
                    }
                }
                if (isSameType) {
                    int i3 = 0;
                    while (i3 < srcAxisList.size()) {
                        if (i3 >= tagAxisList.size()) {
                            tagAxisList.add((Object)((Axis)srcAxisList.get(i3)).copyInstance());
                        }
                        srcRsds = ((Axis)srcAxisList.get(i3)).getSeriesDefinitions();
                        tagRsds = ((Axis)tagAxisList.get(i3)).getSeriesDefinitions();
                        ChartReportItemUtil.copySDListQueryAttributes((EList<SeriesDefinition>)srcRsds, (EList<SeriesDefinition>)tagRsds, isSameType);
                        ++i3;
                    }
                } else {
                    int minsize = srcAxisList.size() > tagAxisList.size() ? tagAxisList.size() : srcAxisList.size();
                    int i4 = 0;
                    while (i4 < minsize) {
                        srcRsds = ((Axis)srcAxisList.get(i4)).getSeriesDefinitions();
                        tagRsds = ((Axis)tagAxisList.get(i4)).getSeriesDefinitions();
                        ChartReportItemUtil.copySDListQueryAttributes((EList<SeriesDefinition>)srcRsds, (EList<SeriesDefinition>)tagRsds, isSameType);
                        ++i4;
                    }
                }
            } else {
                srcRsds = ((SeriesDefinition)((ChartWithoutAxes)srcCM).getSeriesDefinitions().get(0)).getSeriesDefinitions();
                if (tagAxisList.size() > 1) {
                    int i5 = 1;
                    while (i5 < tagAxisList.size()) {
                        tagAxisList.remove(i5);
                        ++i5;
                    }
                }
                tagRsds = ((Axis)tagAxisList.get(0)).getSeriesDefinitions();
                ChartReportItemUtil.copySDListQueryAttributes((EList<SeriesDefinition>)srcRsds, (EList<SeriesDefinition>)tagRsds, isSameType);
            }
        } else {
            tagRsds = ((SeriesDefinition)((ChartWithoutAxes)targetCM).getSeriesDefinitions().get(0)).getSeriesDefinitions();
            srcRsds = srcCM instanceof ChartWithAxes ? ((Axis)((Axis)((ChartWithAxes)srcCM).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions() : ((SeriesDefinition)((ChartWithoutAxes)srcCM).getSeriesDefinitions().get(0)).getSeriesDefinitions();
            ChartReportItemUtil.copySDListQueryAttributes((EList<SeriesDefinition>)srcRsds, (EList<SeriesDefinition>)tagRsds, isSameType);
        }
    }

    private static void copySDListQueryAttributes(EList<SeriesDefinition> srcRsds, EList<SeriesDefinition> tagRsds, boolean sameChartType) {
        int i;
        if (tagRsds.size() > srcRsds.size()) {
            i = tagRsds.size() - 1;
            while (i >= srcRsds.size()) {
                tagRsds.remove(i);
                --i;
            }
        }
        if (sameChartType) {
            i = 0;
            while (i < srcRsds.size()) {
                if (i >= tagRsds.size()) {
                    tagRsds.add((Object)((SeriesDefinition)srcRsds.get(i)).copyInstance());
                }
                SeriesDefinition sd = (SeriesDefinition)srcRsds.get(i);
                SeriesDefinition tagSD = (SeriesDefinition)tagRsds.get(i);
                ChartReportItemUtil.copySDQueryAttributes(sd, tagSD);
                ++i;
            }
        } else {
            int minSDsize = srcRsds.size() > tagRsds.size() ? tagRsds.size() : srcRsds.size();
            int i2 = 0;
            while (i2 < minSDsize) {
                SeriesDefinition sd = (SeriesDefinition)srcRsds.get(i2);
                SeriesDefinition tagSD = (SeriesDefinition)tagRsds.get(i2);
                ChartReportItemUtil.copySDQueryAttributes(sd, tagSD);
                ++i2;
            }
        }
    }

    private static void copySDQueryAttributes(SeriesDefinition sd, SeriesDefinition tagSD) {
        int i;
        int srcSize;
        int tagSize;
        if (sd.getQuery() != null) {
            tagSD.setQuery(sd.getQuery().copyInstance());
        } else {
            tagSD.setQuery(null);
        }
        if (sd.getGrouping() != null) {
            tagSD.setGrouping(sd.getGrouping().copyInstance());
        } else {
            tagSD.setGrouping(null);
        }
        if (sd.isSetSorting()) {
            tagSD.setSorting(sd.getSorting());
        }
        if (sd.getSortKey() != null) {
            tagSD.setSortKey(sd.getSortKey().copyInstance());
        } else {
            tagSD.setSortKey(null);
        }
        if (sd.isSetZOrder()) {
            tagSD.setZOrder(sd.getZOrder());
        }
        if ((tagSize = tagSD.getSeries().size()) > (srcSize = sd.getSeries().size())) {
            i = tagSize - 1;
            while (i >= srcSize) {
                tagSD.getSeries().remove(i);
                --i;
            }
        }
        i = 0;
        while (i < srcSize) {
            Series srcSeries;
            Series tagSeries;
            if (i >= tagSize) {
                tagSeries = ((Series)tagSD.getSeries().get(0)).copyInstance();
                tagSD.getSeries().add((Object)tagSeries);
                srcSeries = (Series)sd.getSeries().get(i);
                tagSeries.getDataDefinition().clear();
                for (Query q : srcSeries.getDataDefinition()) {
                    tagSeries.getDataDefinition().add((Object)q.copyInstance());
                }
            } else {
                tagSeries = (Series)tagSD.getSeries().get(i);
                srcSeries = (Series)sd.getSeries().get(i);
                tagSeries.getDataDefinition().clear();
                for (Query q : srcSeries.getDataDefinition()) {
                    tagSeries.getDataDefinition().add((Object)q.copyInstance());
                }
            }
            ++i;
        }
    }

    public static ScriptExpression newExpression(IModelAdapter adapter, ComputedColumnHandle binding) {
        ExpressionHandle eh = binding.getExpressionProperty("expression");
        if (eh == null || eh.getValue() == null) {
            return null;
        }
        return adapter.adaptExpression((Expression)eh.getValue());
    }

    public static ScriptExpression newExpression(IModelAdapter adapter, AggregationArgumentHandle binding) {
        ExpressionHandle eh = binding.getExpressionProperty("value");
        if (eh == null || eh.getValue() == null) {
            return null;
        }
        return adapter.adaptExpression((Expression)eh.getValue());
    }

    public static List<ScriptExpression> newExpression(IModelAdapter adapter, ParamBindingHandle binding) {
        ExpressionListHandle eh = binding.getExpressionListHandle();
        List exprs = eh.getListValue();
        if (exprs == null) {
            return Collections.emptyList();
        }
        ArrayList<ScriptExpression> ses = new ArrayList<ScriptExpression>(exprs.size());
        for (Expression expr : exprs) {
            ses.add(adapter.adaptExpression(expr));
        }
        return ses;
    }

    public static ScriptExpression newExpression(IModelAdapter adapter, ChartExpressionUtil.ExpressionCodec exprCodec, String expr) {
        exprCodec.decode(expr);
        return adapter.adaptExpression(new Expression((Object)exprCodec.getExpression(), exprCodec.getType()));
    }

    public static IScriptExpression adaptExpression(ChartExpressionUtil.ExpressionCodec exprCodec, IModelAdapter modelAdapter, boolean bCube) {
        return modelAdapter.adaptExpression(new Expression((Object)exprCodec.getExpression(), exprCodec.getType()), bCube ? IModelAdapter.ExpressionLocation.CUBE : IModelAdapter.ExpressionLocation.TABLE);
    }

    public static Expression getExpression(GroupHandle gh) {
        ExpressionHandle eh = gh.getExpressionProperty("keyExpr");
        if (eh != null && eh.getValue() != null) {
            return (Expression)eh.getValue();
        }
        return null;
    }
}

