/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.ITextDataItemModel;

public class TextDataItem
extends ReportItem
implements ITextDataItemModel {
    public TextDataItem() {
    }

    public TextDataItem(String theName) {
        super(theName);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitTextDataItem(this);
    }

    public String getElementName() {
        return "TextData";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public TextDataHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new TextDataHandle(module, this);
        }
        return (TextDataHandle)this.handle;
    }

    public String getDisplayLabel(Module module, int level) {
        String valueExpr;
        String displayLabel = super.getDisplayLabel(module, level);
        if (level == 2 && !StringUtil.isBlank(valueExpr = this.handle(module).getValueExpr())) {
            valueExpr = this.limitStringLength(valueExpr);
            displayLabel = String.valueOf(displayLabel) + "(" + valueExpr + ")";
        }
        return displayLabel;
    }

    public List validate(Module module) {
        List<SemanticException> list = super.validate(module);
        Object valueExpr = this.getProperty(module, "valueExpr");
        if (valueExpr == null) {
            list.add(new PropertyValueException((DesignElement)this, "valueExpr", valueExpr, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }
}

