/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.NameEvent;
import org.eclipse.birt.report.model.api.command.StyleEvent;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StyleElement
extends ReferenceableElement {
    private static final String REPORT_SELECTOR = "report";

    public StyleElement() {
    }

    public StyleElement(String theName) {
        super(theName);
    }

    @Override
    public boolean isStyle() {
        return true;
    }

    @Override
    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        return this.getLocalProperty(module, prop);
    }

    @Override
    public DesignElement getExtendsElement() {
        return null;
    }

    @Override
    public String getExtendsName() {
        return null;
    }

    @Override
    public void setExtendsElement(DesignElement base) {
        assert (false);
    }

    @Override
    public void setExtendsName(String name) {
        assert (false);
    }

    @Override
    protected void broadcastToClients(NotificationEvent ev, Module module) {
        super.broadcastToClients(ev, module);
        ArrayList<String> selectors = new ArrayList<String>();
        if (ev instanceof NameEvent) {
            String oldName = ((NameEvent)ev).getOldName();
            String newName = ((NameEvent)ev).getNewName();
            if (MetaDataDictionary.getInstance().getPredefinedStyle(oldName) != null) {
                selectors.add(oldName);
            }
            if (MetaDataDictionary.getInstance().getPredefinedStyle(newName) != null) {
                selectors.add(newName);
            }
        } else if (MetaDataDictionary.getInstance().getPredefinedStyle(this.getName()) != null) {
            selectors.add(this.getName());
        }
        if (selectors.isEmpty()) {
            return;
        }
        DesignElement tmpContainer = this.getContainer();
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.getContainer() instanceof Theme) {
            Theme containerTheme = (Theme)tmpContainer;
            if (containerTheme.hasReferences()) {
                List<BackRef> refs = ((Theme)tmpContainer).getClientList();
                int i = 0;
                while (i < refs.size()) {
                    modules.add((Module)refs.get(i).getElement());
                    ++i;
                }
            }
        } else {
            modules.add(module);
        }
        int i = 0;
        while (i < modules.size()) {
            this.broadcastToModule((Module)modules.get(i), selectors);
            ++i;
        }
    }

    private void broadcastToModule(Module module, List<String> selectorList) {
        assert (!selectorList.isEmpty());
        for (String selectorName : selectorList) {
            if (REPORT_SELECTOR.equals(selectorName)) {
                StyleEvent event = null;
                event = new StyleEvent(module);
                event.setDeliveryPath(2);
                module.broadcast(event);
                continue;
            }
            this.broadcastToSelectedElementsInSlot(module, new ContainerContext((DesignElement)module, 5), selectorName);
            this.broadcastToSelectedElementsInSlot(module, new ContainerContext((DesignElement)module, 4), selectorName);
            if (!(module instanceof ReportDesign)) continue;
            this.broadcastToSelectedElementsInSlot(module, new ContainerContext((DesignElement)module, 6), selectorName);
            this.broadcastToSelectedElementsInSlot(module, new ContainerContext((DesignElement)module, 7), selectorName);
        }
    }

    private void broadcastToSelectedElementsInSlot(Module module, ContainerContext containerInfor, String selectorName) {
        Iterator<DesignElement> iter = containerInfor.getContents(module).iterator();
        StyleEvent event = null;
        while (iter.hasNext()) {
            ElementDefn elementDefn;
            DesignElement element = iter.next();
            event = new StyleEvent(element);
            event.setDeliveryPath(2);
            List<String> list = element.getElementSelectors();
            String selector = null;
            int i = 0;
            while (i < list.size()) {
                String tmpSelector = list.get(i);
                if (tmpSelector.equalsIgnoreCase(selectorName)) {
                    selector = tmpSelector;
                    break;
                }
                ++i;
            }
            if (selector != null) {
                element.broadcast(event, module);
                continue;
            }
            if (this.checkSlotSelector(element, selectorName, event, module) || !(elementDefn = (ElementDefn)element.getDefn()).isContainer()) continue;
            int i2 = 0;
            while (i2 < elementDefn.getSlotCount()) {
                this.broadcastToSelectedElementsInSlot(module, new ContainerContext(element, i2), selectorName);
                ++i2;
            }
            List<IElementPropertyDefn> properties = elementDefn.getContents();
            int i3 = 0;
            while (i3 < properties.size()) {
                IElementPropertyDefn propDefn = properties.get(i3);
                this.broadcastToSelectedElementsInSlot(module, new ContainerContext(element, propDefn.getName()), selectorName);
                ++i3;
            }
        }
    }

    private boolean checkSlotSelector(DesignElement element, String selectorName, NotificationEvent event, Module module) {
        String selector = element.getContainerInfo().getSelector();
        if (selector != null && selector.equalsIgnoreCase(selectorName)) {
            element.broadcast(event, module);
            return true;
        }
        return false;
    }
}

