/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.util.CopyUtil;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.gef.commands.Command;

public class PasteCommand
extends Command {
    protected static final Logger logger = Logger.getLogger(PasteCommand.class.getName());
    private DesignElementHandle sourceHandle;
    private Object newContainer;
    private DesignElementHandle afterHandle;
    private Object cloneElement;
    private boolean isCut = false;
    private int slotID = -1;
    private String contentString = null;
    private int position = -1;
    private boolean isCloned = false;

    public PasteCommand(DesignElementHandle sourceHandle, Object newContainer, DesignElementHandle afterHandle, boolean isCut) {
        this.sourceHandle = sourceHandle;
        this.cloneElement = CopyUtil.copy((DesignElementHandle)sourceHandle);
        this.newContainer = newContainer;
        this.afterHandle = afterHandle;
        this.isCut = isCut;
        this.isCloned = true;
    }

    public PasteCommand(DesignElementHandle sourceHandle, Object newContainer, int position, boolean isCut) {
        this.sourceHandle = sourceHandle;
        this.cloneElement = CopyUtil.copy((DesignElementHandle)sourceHandle);
        this.newContainer = newContainer;
        this.position = position;
        this.isCut = isCut;
        this.isCloned = true;
    }

    public PasteCommand(IDesignElement cloneElement, Object newContainer, DesignElementHandle afterHandle) {
        this.cloneElement = cloneElement;
        this.newContainer = newContainer;
        this.afterHandle = afterHandle;
        this.isCloned = false;
    }

    public PasteCommand(IDesignElement cloneElement, Object newContainer, int position) {
        this.cloneElement = cloneElement;
        this.newContainer = newContainer;
        this.position = position;
        this.isCloned = false;
    }

    public PasteCommand(IElementCopy cloneElement, Object newContainer, int position) {
        this.cloneElement = cloneElement;
        this.newContainer = newContainer;
        this.position = position;
        this.isCloned = false;
    }

    public void execute() {
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("PasteCommand >> Starts ...");
        }
        try {
            if (!this.isCut || this.sourceHandle == null || this.sourceHandle.getContainer() == null) {
                this.isCut = false;
            }
            this.calculatePositionAndSlotId();
            this.dropSourceHandle(this.sourceHandle);
            ModuleHandle currentDesignHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
            DesignElementHandle newHandle = this.cloneElement instanceof IDesignElement ? this.copyNewHandle((IDesignElement)this.cloneElement, currentDesignHandle) : null;
            this.addHandleToReport(newHandle);
        }
        catch (Exception e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("PasteCommand >> Failed.");
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void addHandleToReport(DesignElementHandle newHandle) throws ContentException, NameException, SemanticException {
        SlotHandle slotHandle = null;
        DesignElementHandle containerHandle = null;
        if (this.newContainer instanceof DesignElementHandle) {
            slotHandle = ((DesignElementHandle)this.newContainer).getSlot(this.slotID);
            containerHandle = (DesignElementHandle)this.newContainer;
        } else if (this.newContainer instanceof SlotHandle) {
            slotHandle = (SlotHandle)this.newContainer;
            containerHandle = ((SlotHandle)this.newContainer).getElementHandle();
        } else if (this.newContainer instanceof PropertyHandle) {
            containerHandle = ((PropertyHandle)this.newContainer).getElementHandle();
        }
        if (this.cloneElement instanceof IElementCopy) {
            if (slotHandle != null) {
                CopyUtil.paste((IElementCopy)((IElementCopy)this.cloneElement), (DesignElementHandle)containerHandle, (int)this.slotID, (int)this.position);
            } else if (this.newContainer instanceof PropertyHandle) {
                CopyUtil.paste((IElementCopy)((IElementCopy)this.cloneElement), (DesignElementHandle)containerHandle, (String)((PropertyHandle)this.newContainer).getPropertyDefn().getName(), (int)this.position);
            } else if (this.newContainer instanceof DesignElementHandle) {
                CopyUtil.paste((IElementCopy)((IElementCopy)this.cloneElement), (DesignElementHandle)containerHandle, (String)DEUtil.getDefaultContentName(this.newContainer), (int)this.position);
            }
        } else if (newHandle != null) {
            if (slotHandle != null) {
                slotHandle.paste(newHandle, this.position);
            } else if (this.newContainer instanceof PropertyHandle) {
                ((PropertyHandle)this.newContainer).paste(newHandle, this.position);
            } else if (this.newContainer instanceof DesignElementHandle) {
                ((DesignElementHandle)this.newContainer).getPropertyHandle(this.contentString).paste(newHandle, this.position);
            }
        }
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("PasteCommand >>  Finished. Paste " + this.cloneElement + " to the container " + slotHandle != null ? Integer.valueOf(slotHandle.getSlotID()) : String.valueOf(DEUtil.getDefaultContentName(this.newContainer)) + ",Position: " + this.position);
        }
    }

    private void calculatePositionAndSlotId() {
        int oldPosition;
        DesignElementHandle container = null;
        if (this.newContainer instanceof DesignElementHandle) {
            this.slotID = DEUtil.getDefaultSlotID(this.newContainer);
            if (this.slotID == -1) {
                this.contentString = DEUtil.getDefaultContentName(this.newContainer);
            }
            container = (DesignElementHandle)this.newContainer;
        } else if (this.newContainer instanceof SlotHandle) {
            this.slotID = ((SlotHandle)this.newContainer).getSlotID();
            container = ((SlotHandle)this.newContainer).getElementHandle();
        } else {
            return;
        }
        if (this.afterHandle != null) {
            this.position = this.slotID == -1 ? DEUtil.findInsertPosition(container, this.afterHandle, this.contentString) : DEUtil.findInsertPosition(container, this.afterHandle, this.slotID);
        } else if (this.position > -1 && this.isCut && this.sourceHandle.getContainer() == container && (oldPosition = DEUtil.findInsertPosition(container, this.sourceHandle, this.slotID)) < this.position) {
            --this.position;
        }
    }

    private void dropSourceHandle(DesignElementHandle oldHandle) throws SemanticException {
        if (this.isCut) {
            oldHandle.drop();
        }
    }

    private DesignElementHandle copyNewHandle(IDesignElement element, ModuleHandle currentDesignHandle) throws CloneNotSupportedException {
        IDesignElement newElement = this.isCloned ? element : (IDesignElement)element.clone();
        DesignElementHandle handle = newElement.getHandle(currentDesignHandle.getModule());
        if (this.newContainer instanceof ThemeHandle) {
            currentDesignHandle.rename((DesignElementHandle)((ThemeHandle)this.newContainer), handle);
        } else if (this.newContainer instanceof SlotHandle && ((SlotHandle)this.newContainer).getElementHandle() instanceof ThemeHandle) {
            currentDesignHandle.rename(((SlotHandle)this.newContainer).getElementHandle(), handle);
        } else {
            currentDesignHandle.rename(handle);
        }
        return handle;
    }

    public boolean canExecute() {
        if (this.cloneElement == null) {
            return false;
        }
        if (this.newContainer instanceof PropertyHandle && this.cloneElement instanceof IElementCopy && this.newContainer instanceof DesignElementHandle) {
            PropertyHandle targetHandle = (PropertyHandle)this.newContainer;
            return CopyUtil.canPaste((IElementCopy)((IElementCopy)this.cloneElement), (DesignElementHandle)((DesignElementHandle)this.newContainer), (String)targetHandle.getPropertyDefn().getName()).canPaste();
        }
        DesignElementHandle childHandle = this.sourceHandle;
        if (childHandle == null) {
            if (this.cloneElement instanceof IDesignElement) {
                childHandle = ((IDesignElement)this.cloneElement).getHandle(SessionHandleAdapter.getInstance().getReportDesignHandle().getModule());
            } else if (this.cloneElement instanceof IElementCopy) {
                childHandle = ((IElementCopy)this.cloneElement).getHandle(SessionHandleAdapter.getInstance().getReportDesignHandle());
            }
        }
        return DNDUtil.handleValidateTargetCanContain(this.newContainer, childHandle) && DNDUtil.handleValidateTargetCanContainMore(this.newContainer, 1);
    }
}

