/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.yaml.bean;

import hiro.yoshioka.sql.yaml.bean.Case;
import hiro.yoshioka.sql.yaml.bean.ExecuteTimingType;
import hiro.yoshioka.sql.yaml.bean.Setup;
import hiro.yoshioka.sql.yaml.bean.TearDown;
import hiro.yoshioka.sql.yaml.bean.TestPatternType;
import hiro.yoshioka.util.StringUtil;

public class Entry {
    public static final String COMMENT = "#-----------------------";
    public Setup setup = new Setup();
    public TearDown teardown = new TearDown();
    public String title;
    public String execute_timing = ExecuteTimingType.ANY_TIME.getMessage();
    public long totalTimeLimit;
    public TestPatternType testPattern = TestPatternType.SQL_PMS;
    public Case[] cases = new Case[0];

    public Setup getSetup() {
        return this.setup;
    }

    public TearDown getTeardown() {
        return this.teardown;
    }

    public ExecuteTimingType getExecuteTimingType() {
        ExecuteTimingType[] executeTimingTypeArray = ExecuteTimingType.values();
        int n = executeTimingTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExecuteTimingType timing = executeTimingTypeArray[n2];
            if (timing.name().equalsIgnoreCase(this.execute_timing)) {
                return timing;
            }
            if (timing.getMessage().equalsIgnoreCase(this.execute_timing)) {
                return timing;
            }
            ++n2;
        }
        return ExecuteTimingType.ANY_TIME;
    }

    public Case[] getCases() {
        return this.cases;
    }

    public void setCases(Case[] cases) {
        this.cases = cases;
    }

    public long getTotalTimeLimit() {
        return this.totalTimeLimit;
    }

    public String dump() {
        StringBuilder ret = new StringBuilder();
        ret.append(String.format("project: %n", new Object[0]));
        ret.append(String.format("title: \"%s\"%n", Case.escQuot(this.title)));
        ret.append(String.format("totalTimeLimit: %d%n", this.totalTimeLimit));
        ret.append(String.format("execute_timing: \"%s\"%n", this.execute_timing));
        ret.append(String.format("%s%n# for setup %n%s%n", COMMENT, COMMENT));
        this.setup.dump(ret);
        ret.append(String.format("%s%n# for test cases. %n%s%n", COMMENT, COMMENT));
        ret.append(String.format("cases: %n", new Object[0]));
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case caze = caseArray[n2];
            caze.dump(ret);
            ++n2;
        }
        ret.append(String.format("%s%n# for teardown %n%s%n", COMMENT, COMMENT));
        this.teardown.dump(ret);
        return ret.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("Entry [title:%s]%n", this.title));
        if (this.cases == null) {
            buf.append(" case is nothing...");
        } else {
            int i = 0;
            while (i < this.cases.length) {
                buf.append(String.format("  CASE[%d] %s%n", i, this.cases[i]));
                ++i;
            }
        }
        return buf.toString();
    }

    public boolean hasProjectTitle() {
        return !StringUtil.isEmpty((Object)this.title);
    }
}

