/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.AddResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScriptLibHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.structures.ScriptLib;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;

public class JarFileFormProvider
extends AbstractFormHandleProvider {
    private static final int[] COLUMN_WIDTHS = new int[]{300};
    private static final String[] COLUMNS = new String[]{Messages.getString((String)"JarFileFormProvider.Column.Name")};
    private static final String TITLE = Messages.getString((String)"ReportPageGenerator.List.Resources.JarFile");
    private static final String EMPTY_STRING = "";
    private ModuleHandle inputElement;

    public String[] getColumnNames() {
        return COLUMNS;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public String getDisplayName() {
        return TITLE;
    }

    public CellEditor[] getEditors(Table table) {
        return null;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws Exception {
        this.inputElement.shiftScriptLibs(oldPos, newPos);
        return true;
    }

    public boolean doDeleteItem(int pos) throws Exception {
        if (this.getElements(this.inputElement).length <= 0) {
            return false;
        }
        ScriptLibHandle scriptLibHandle = (ScriptLibHandle)this.getElements(this.inputElement)[pos];
        if (scriptLibHandle != null && scriptLibHandle.getStructure() != null && scriptLibHandle.getStructure() instanceof ScriptLib) {
            ScriptLib scriptLib = (ScriptLib)scriptLibHandle.getStructure();
            this.inputElement.dropScriptLib(scriptLib);
        }
        return true;
    }

    public boolean doAddItem(int pos) throws Exception {
        AddResourceFileFolderSelectionDialog dialog = new AddResourceFileFolderSelectionDialog(new String[]{"*.jar"}, new String[]{".jar"});
        dialog.setHelpDialogId("org.eclipse.birt.cshelp.AddJarResourceFileFolderSelectionDialog_ID");
        dialog.setExistFiles(this.getElmentNames(this.inputElement));
        if (dialog.open() != 0) {
            return false;
        }
        Object[] selection = dialog.getResult();
        int length = selection.length;
        int i = 0;
        while (i < length) {
            String fileName = dialog.getPath(i);
            ScriptLib lib = StructureFactory.createScriptLib();
            lib.setName(fileName);
            this.inputElement.addScriptLib(lib);
            ++i;
        }
        return true;
    }

    public boolean doEditItem(int pos) {
        return false;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ScriptLibHandle) {
            ScriptLibHandle srcriptLibHandle = (ScriptLibHandle)element;
            if (columnIndex == 0) {
                return srcriptLibHandle.getName();
            }
        }
        return EMPTY_STRING;
    }

    public Image getImage(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        List list = new ArrayList();
        if (inputElement instanceof List) {
            inputElement = ((List)inputElement).get(0);
        }
        if (inputElement instanceof ModuleHandle) {
            this.inputElement = (ModuleHandle)inputElement;
            list = ((ModuleHandle)inputElement).getAllScriptLibs();
            if (list == null || list.size() == 0) {
                return new ScriptLibHandle[0];
            }
        }
        return list.toArray();
    }

    private String[] getElmentNames(Object inputElement) {
        Object[] obj = this.getElements(inputElement);
        String[] names = new String[obj.length];
        int i = 0;
        while (i < names.length) {
            names[i] = ((ScriptLibHandle)obj[i]).getName();
            ++i;
        }
        return names;
    }

    public boolean canModify(Object element, String property) {
        return false;
    }

    public Object getValue(Object element, String property) {
        return null;
    }

    public boolean modify(Object data, String property, Object value) throws Exception {
        return false;
    }

    public boolean needRefreshed(NotificationEvent event) {
        if (!(event instanceof PropertyEvent)) {
            return false;
        }
        PropertyEvent propertyEvent = (PropertyEvent)event;
        return propertyEvent.getPropertyName().equals("scriptLibs");
    }
}

