/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view;

import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.ui.util.AnimatedGifCanvas;
import hiro.yoshioka.wolfdbmanager.Activator;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ConnectionStatusComposite
extends Composite
implements IRequestListener {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    CLabel userConnectionLabel;
    CLabel systemConnectionLabel;
    String userMessage;
    String systemMessage;
    AnimatedGifCanvas animation;

    public ConnectionStatusComposite(Composite parent, int style) {
        super(parent, style);
        this.createPartControl(this);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Composite top = new Composite(parent, 0);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.horizontalSpacing = 0;
        layout2.verticalSpacing = 0;
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        top.setLayout((Layout)layout2);
        File skin = new File(ImageManager.ICON_File, "view/99request_executing.gif");
        String file = null;
        if (skin.exists() && skin.isFile()) {
            file = skin.getAbsolutePath();
            URL url = null;
            try {
                url = new URL("file:" + skin.getAbsolutePath());
                file = FileLocator.toFileURL((URL)url).getFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            URL url = Activator.getURL("icons/view/99request_executing.gif");
            try {
                file = FileLocator.toFileURL((URL)url).getFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        top.setLayoutData((Object)new GridData(1808));
        this.animation = new AnimatedGifCanvas(parent, file);
        this.userConnectionLabel = new CLabel(top, 2048);
        this.userConnectionLabel.setLayoutData((Object)new GridData(768));
        this.systemConnectionLabel = new CLabel(top, 2048);
        this.systemConnectionLabel.setLayoutData((Object)new GridData(768));
        System.out.println("SQL Request status View created................");
    }

    public void dispose() {
        super.dispose();
    }

    public void called_pre(Request request, SQLOperationType operation) {
        this.animation.startAnimation();
        SQLServerThread server = SQLServerThread.getSQLServer();
        this.userMessage = String.format("Req:%03d (End:%03d)", server.getRequestCount(), server.getEndOfRequestCount());
        this.resetMessage();
    }

    public void beginTask(String taskName, int row) {
    }

    public void called_done(Request request, SQLOperationType operation, ConnectionProperties properties, Object o) {
        this.fLogger.fatal((Object)" doneeeeeeeeeee. ");
        Collection requestCollections = SQLServerThread.getSQLServer().listActiveRequest();
        if (requestCollections.size() == 0) {
            this.animation.stopAnimation();
        }
        SQLServerThread server = SQLServerThread.getSQLServer();
        this.userMessage = String.format("Req:%03d (End:%03d)", server.getRequestCount(), server.getEndOfRequestCount());
    }

    public void subTask(String subTaskName) {
    }

    public void worked(int i) {
    }

    private void resetMessage() {
        try {
            Application.exec(new Runnable(){

                @Override
                public void run() {
                    if (!ConnectionStatusComposite.this.userConnectionLabel.isDisposed()) {
                        ConnectionStatusComposite.this.userConnectionLabel.setText(ConnectionStatusComposite.this.userMessage);
                        ConnectionStatusComposite.this.systemConnectionLabel.setText(ConnectionStatusComposite.this.systemMessage);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

