/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.ui.action.SQLAction;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.Date;

public class DisConnectAction
extends SQLAction {
    ExplorerView view;

    public DisConnectAction(ExplorerView view, ConnectionProperties connectionProperties) {
        super(SQLOperationType.CLOSE, 1, connectionProperties);
        this.view = view;
        String text = "(Dis)Connect";
        if (connectionProperties != null) {
            text = String.format("Disconnect to %s", connectionProperties.getDisplayString());
        }
        this.configureAction(text, text, ImageUtil.getImageDescriptor((String)"action/33disconnect.gif"));
        if (view == null) {
            view = (ExplorerView)Application.findActiveView("ExplorerID");
        }
    }

    public DisConnectAction() {
        this(null, null);
    }

    @Override
    public void called_done(Request request, SQLOperationType operation, ConnectionProperties properteis, Object o) {
        this.setEnabled(true);
        Application.setStatus(String.format("[%tT] [%s] Done:%s result:%b", new Date(), properteis.getDisplayString(), operation.name(), request.result));
        Throwable ex = this.fRequest.getException();
        if (ex != null) {
            Application.openErrorDialog(null, "DisConnection Error", ex);
        }
    }
}

