/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.job.DBRefreshJob;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.util.ConnectionSettingDialog;
import hiro.yoshioka.ui.action.Messages;
import hiro.yoshioka.ui.action.SQLAction;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public class ConnectAction
extends SQLAction {
    ExplorerView view;

    public ConnectAction(ExplorerView view, ConnectionProperties connectionProperties) {
        super(SQLOperationType.CONNECT, 1, connectionProperties);
        this.view = view;
        String text = Messages.getString("ConnectAction.DisplayString");
        if (connectionProperties != null) {
            text = String.format(Messages.getString("ConnectAction.DisplayStringAtWithConnectionProperties"), connectionProperties.getDisplayString());
        }
        this.configureAction(text, text, ImageUtil.getImageDescriptor((String)"action/32connect.gif"));
        if (view == null) {
            view = (ExplorerView)Application.findActiveView("ExplorerID");
        }
    }

    public ConnectAction() {
        this(null, null);
    }

    @Override
    public void run() {
        try {
            this.setEnabled(false);
            if (this.view == null) {
                ConnectionSettingDialog dialog = null;
                List cons = null;
                cons = SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionList();
                if (cons.size() == 0) {
                    Application.openDialog(Messages.getString("ConnectAction.information"), Messages.getString("ConnectAction.information_text"), 2);
                    return;
                }
                dialog = new ConnectionSettingDialog(Display.getCurrent().getActiveShell(), cons, this.connectionProperties, 1);
                int ret = dialog.open();
                if (ret == 200) {
                    this.connectionProperties = dialog.getSelectedConnectionProperties();
                    this.fOperation = SQLOperationType.CONNECT;
                } else if (ret == 300) {
                    this.connectionProperties = dialog.getSelectedConnectionProperties();
                    this.fOperation = SQLOperationType.CLOSE;
                } else if (ret == 400) {
                    this.connectionProperties = dialog.getSelectedConnectionProperties();
                    this.fOperation = SQLOperationType.CANSEL;
                } else {
                    return;
                }
            }
            try {
                this.fRequest = new Request(this.fOperation, this.connectionProperties);
                this.fRequest.addListener((IRequestListener)this);
                SQLServerThread.putRequest((Request)this.fRequest);
            }
            catch (RuntimeException e) {
                this.fLogger.error((Object)"", (Throwable)e);
            }
        }
        finally {
            if (this.finalClearConnectionFlg) {
                this.connectionProperties = null;
            }
            this.setEnabled(true);
        }
    }

    @Override
    public void called_done(Request request, SQLOperationType operation, ConnectionProperties properteis, Object o) {
        Application.setStatus(String.format(Messages.getString("ConnectAction.result_message"), new Date(), properteis.getDisplayString(), operation.name(), request.result));
        Throwable ex = this.fRequest.getException();
        if (ex != null) {
            Application.openErrorDialog(null, String.format(Messages.getString("ConnectAction.error_message"), properteis.getDisplayString()), ex);
        }
        if (this.fOperation == SQLOperationType.CONNECT && properteis.isConnected() && properteis.isCaptureResourceAfterTheConnectProcess()) {
            DBRefreshJob job = new DBRefreshJob(SQLOperationType.RESOURCE_CAPTION, properteis, properteis);
            job.setUser(true);
            job.schedule();
        }
    }
}

