/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.selenium.inspect;

import hiro.yoshioka.selenium.inspect.Messages;

public enum ExpectionType {
    equals(Messages.ExpectionType_equals, "="),
    match(Messages.ExpectionType_match, null),
    contain(Messages.ExpectionType_contain, null),
    greater_equal(Messages.ExpectionType_greater_equal, ">="),
    less_equal(Messages.ExpectionType_less_equal, "<="),
    greater_than(Messages.ExpectionType_greater_than, ">"),
    less_than(Messages.ExpectionType_less_than, "<"),
    increase(Messages.ExpectionType_increase, null),
    decrease(Messages.ExpectionType_decrease, null),
    same_as_before(Messages.ExpectionType_same_as_before, null),
    issue_c_or_u_or_d(Messages.ExpectionType_IssueCreateUpdateDelete, null);

    private String title;
    private String comparator;

    private ExpectionType(String title, String comparator) {
        this.title = title;
        this.comparator = comparator;
    }

    public String getTitle() {
        return this.title;
    }

    public String getComparator() {
        return this.comparator;
    }

    public static ExpectionType parse(String text) {
        ExpectionType[] expectionTypeArray = ExpectionType.values();
        int n = expectionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpectionType action = expectionTypeArray[n2];
            if (action.name().equalsIgnoreCase(text)) {
                return action;
            }
            if (action.getTitle().equals(text)) {
                return action;
            }
            if (action.getComparator() != null && action.getComparator().equals(text)) {
                return action;
            }
            ++n2;
        }
        return null;
    }

    public boolean isEquals() {
        return equals.equals((Object)this);
    }

    public boolean isNumericType() {
        switch (this) {
            case equals: 
            case greater_equal: 
            case less_equal: 
            case greater_than: 
            case less_than: {
                return true;
            }
        }
        return false;
    }

    public boolean needsBeforeSql() {
        switch (this) {
            case equals: 
            case greater_equal: 
            case less_equal: 
            case greater_than: 
            case less_than: 
            case increase: 
            case decrease: 
            case same_as_before: 
            case issue_c_or_u_or_d: {
                return true;
            }
        }
        return false;
    }

    public boolean needsQuery() {
        switch (this) {
            case issue_c_or_u_or_d: {
                return true;
            }
        }
        return false;
    }
}

