/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.preferences;

import hiro.yoshioka.preferences.Messages;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.util.SQLHistroyManager;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ApplicationConversionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected static Log fLogger = LogFactory.getLog(ApplicationConversionPreferencePage.class.getClass());

    protected Control createContents(Composite parent) {
        try {
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            ScrolledForm root = toolkit.createScrolledForm(parent);
            root.setText(Messages.ApplicationConversionPreferencePage_ApplicationConversionPreferencePage);
            root.getBody().setLayout((Layout)new GridLayout());
            Section section0 = toolkit.createSection(root.getBody(), 320);
            section0.setText(Messages.ApplicationConversionPreferencePage_MigrateApplication);
            Composite inner0 = toolkit.createComposite((Composite)section0);
            GridLayout layout0 = new GridLayout();
            inner0.setLayout((Layout)layout0);
            layout0.numColumns = 3;
            toolkit.createLabel(inner0, Messages.ApplicationConversionPreferencePage_OldVerWolfDBManagerTopDir);
            toolkit.createLabel(inner0, ":");
            Button btF = new Button(inner0, 8);
            btF.setText(Messages.ApplicationConversionPreferencePage_Dir);
            btF.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(e.display.getActiveShell());
                    String path = dialog.open();
                    if (path != null) {
                        CopyList cp = new CopyList(path);
                        String ready = cp.ready();
                        if (ready.length() > 0) {
                            if (MessageDialog.openConfirm((Shell)e.display.getActiveShell(), (String)Messages.ApplicationConversionPreferencePage_Conversion, (String)ready)) {
                                cp.copy();
                                Application.openDialog("Message", Messages.ApplicationConversionPreferencePage_SuccessfulRestartWolf, 2);
                                Application.restart();
                            }
                        } else {
                            Application.openDialog("Error", Messages.ApplicationConversionPreferencePage_NothingConverion, 1);
                        }
                    }
                }
            });
            section0.setClient((Control)inner0);
            section0.setLayoutData((Object)new GridData(768));
            return root;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void init(IWorkbench workbench) {
    }

    public static void fileCopy(File sf, File df) {
        block23: {
            FileChannel sc = null;
            AbstractInterruptibleChannel dc = null;
            try {
                try {
                    sc = new FileInputStream(sf).getChannel();
                    dc = new FileOutputStream(df).getChannel();
                    ((FileChannel)dc).transferFrom(sc, 0L, sc.size());
                }
                catch (IOException e) {
                    fLogger.error((Object)"", (Throwable)e);
                    e.printStackTrace();
                    if (dc != null) {
                        try {
                            dc.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (sc != null) {
                        try {
                            sc.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (dc != null) {
                    try {
                        dc.close();
                    }
                    catch (IOException iOException) {}
                }
                if (sc != null) {
                    try {
                        sc.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (dc != null) {
                try {
                    dc.close();
                }
                catch (IOException iOException) {}
            }
            if (sc != null) {
                try {
                    sc.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    class CopyList {
        File history;
        File w_config_dir;
        ArrayList<File> sqlList = new ArrayList();
        ArrayList<File> lstList = new ArrayList();
        ArrayList<File> settingList = new ArrayList();

        public CopyList(String path) {
            int i;
            File lst;
            File[] children;
            File sql;
            File myProject;
            File dir = new File(path);
            this.history = new File(dir, "history.xml");
            if (!this.history.exists()) {
                this.history = null;
            }
            this.w_config_dir = new File(dir, "w_config");
            if (!this.w_config_dir.exists()) {
                this.w_config_dir = null;
            }
            if (!(myProject = new File(dir, "MyProject")).exists()) {
                File workDir = new File(dir, "workspace");
                if (!workDir.exists()) {
                    workDir = new File(dir, "wk");
                }
                if (workDir.exists()) {
                    myProject = new File(workDir, "MyProject");
                }
            }
            if (myProject.exists()) {
                sql = new File(myProject, "sql");
                if (sql.exists() && sql.isDirectory()) {
                    children = sql.listFiles();
                    int i2 = 0;
                    while (i2 < children.length) {
                        if (children[i2].isFile() && children[i2].length() > 0L) {
                            this.sqlList.add(children[i2]);
                        }
                        ++i2;
                    }
                }
                if ((lst = new File(myProject, "lst")).exists() && lst.isDirectory()) {
                    File[] children2 = lst.listFiles();
                    i = 0;
                    while (i < children2.length) {
                        if (children2[i].isFile() && children2[i].length() > 0L) {
                            this.lstList.add(children2[i]);
                        }
                        ++i;
                    }
                }
            } else {
                sql = new File(dir, "sql");
                if (sql.exists() && sql.isDirectory()) {
                    children = sql.listFiles();
                    int i3 = 0;
                    while (i3 < children.length) {
                        if (children[i3].isFile() && children[i3].length() > 0L) {
                            this.sqlList.add(children[i3]);
                        }
                        ++i3;
                    }
                }
                if ((lst = new File(dir, "lst")).exists() && lst.isDirectory()) {
                    File[] children3 = lst.listFiles();
                    i = 0;
                    while (i < children3.length) {
                        if (children3[i].isFile() && children3[i].length() > 0L) {
                            this.lstList.add(children3[i]);
                        }
                        ++i;
                    }
                }
            }
            File setting = new File(dir, "workspace/.metadata/.plugins/org.eclipse.core.runtime/.settings");
            if (fLogger.isTraceEnabled()) {
                fLogger.trace((Object)("setting [" + setting + "]"));
                fLogger.trace((Object)("setting.exists() [" + setting.exists() + "]"));
                fLogger.trace((Object)("setting.isDirectory() [" + setting.isDirectory() + "]"));
            }
            if (setting.exists() && setting.isDirectory()) {
                children = setting.listFiles();
                if (fLogger.isTraceEnabled()) {
                    fLogger.trace((Object)("children.length [" + children.length + "]"));
                }
                int i4 = 0;
                while (i4 < children.length) {
                    if (fLogger.isTraceEnabled()) {
                        fLogger.trace((Object)(children[i4] + "children[i].length() [" + children[i4].length() + "]"));
                    }
                    if (children[i4].isFile() && children[i4].length() > 0L) {
                        this.settingList.add(children[i4]);
                    }
                    ++i4;
                }
            }
        }

        public void copy() {
            try {
                IFile file;
                IFolder folder;
                File f;
                if (this.history != null) {
                    ApplicationConversionPreferencePage.fileCopy(this.history, new File("history.xml"));
                }
                if (this.w_config_dir != null && (f = new File(this.w_config_dir, "connections.def")).exists()) {
                    SQLServerThread.getSQLServer().copyConfigFrom(this.w_config_dir);
                }
                int i = 0;
                while (i < this.sqlList.size()) {
                    File sql = this.sqlList.get(i);
                    folder = ResourceMarker.getFolder(null, ResourceMarker.sqlFolder);
                    file = ResourceMarker.createFile(folder, sql.getName());
                    ApplicationConversionPreferencePage.fileCopy(sql, ResourceMarker.cnvFile(file));
                    ++i;
                }
                i = 0;
                while (i < this.lstList.size()) {
                    File lst = this.lstList.get(i);
                    folder = ResourceMarker.getFolder(null, ResourceMarker.lstFolder);
                    file = ResourceMarker.createFile(folder, lst.getName());
                    ApplicationConversionPreferencePage.fileCopy(lst, ResourceMarker.cnvFile(file));
                    ++i;
                }
                File rdir = new File("workspace/.metadata/.plugins/org.eclipse.core.runtime/.settings");
                rdir.mkdirs();
                int i2 = 0;
                while (i2 < this.settingList.size()) {
                    File setting = this.settingList.get(i2);
                    ApplicationConversionPreferencePage.fileCopy(setting, new File(rdir, setting.getName()));
                    ++i2;
                }
                SQLHistroyManager.getInstance().load();
            }
            catch (Exception e) {
                fLogger.error((Object)"", (Throwable)e);
                e.printStackTrace();
            }
        }

        public String ready() {
            StringBuilder buf = new StringBuilder();
            if (fLogger.isTraceEnabled()) {
                fLogger.trace((Object)("history=" + this.history));
            }
            if (this.history != null) {
                buf.append("History[").append(this.history.length()).append("byte] ");
            }
            if (fLogger.isTraceEnabled()) {
                fLogger.trace((Object)("sqlList.size()=" + this.sqlList.size()));
            }
            if (this.sqlList.size() > 0) {
                buf.append("sqlList[").append(this.sqlList.size()).append("Files] ");
            }
            if (fLogger.isTraceEnabled()) {
                fLogger.trace((Object)("lstList.size()=" + this.lstList.size()));
            }
            if (this.lstList.size() > 0) {
                buf.append("lstList[").append(this.lstList.size()).append("Files] ");
            }
            if (fLogger.isTraceEnabled()) {
                fLogger.trace((Object)("settingList.size()=" + this.settingList.size()));
            }
            if (this.settingList.size() > 0) {
                buf.append("settingList[").append(this.settingList.size()).append("Files] ");
            }
            return buf.toString();
        }
    }
}

